/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.AbstractSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.manual.segment.TextSegment;
import net.minecraft.client.gui.FontRenderer;

abstract class BasicTextSegment
extends AbstractSegment
implements Segment {
    private static final Set<Character> BREAKS = ImmutableSet.of((Object)Character.valueOf(' '), (Object)Character.valueOf('.'), (Object)Character.valueOf(','), (Object)Character.valueOf(':'), (Object)Character.valueOf(';'), (Object)Character.valueOf('!'), (Object[])new Character[]{Character.valueOf('?'), Character.valueOf('_'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('\\')});
    private static final Set<String> LISTS = ImmutableSet.of((Object)"- ", (Object)"* ");
    private String rootPrefix = null;

    BasicTextSegment() {
    }

    private String getRootPrefix() {
        if (this.rootPrefix == null) {
            TextSegment segment = (TextSegment)this.root();
            this.rootPrefix = segment.text().substring(0, Math.min(2, segment.text().length()));
        }
        return this.rootPrefix;
    }

    @Override
    public int nextX(int indent, int maxWidth, FontRenderer renderer) {
        if (this.isLast()) {
            return 0;
        }
        int currentX = indent;
        String chars = this.text();
        if (this.ignoreLeadingWhitespace() && indent == 0) {
            chars = chars.substring(BasicTextSegment.indexOfFirstNonWhitespace(chars));
        }
        int wrapIndent = this.computeWrapIndent(renderer);
        int numChars = this.maxChars(chars, maxWidth - indent, maxWidth - wrapIndent, renderer);
        while (chars.length() > numChars) {
            chars = chars.substring(numChars);
            chars = chars.substring(BasicTextSegment.indexOfFirstNonWhitespace(chars));
            numChars = this.maxChars(chars, maxWidth - wrapIndent, maxWidth - wrapIndent, renderer);
            currentX = wrapIndent;
        }
        return currentX + this.stringWidth(chars, renderer);
    }

    @Override
    public int nextY(int indent, int maxWidth, FontRenderer renderer) {
        int lines = 0;
        String chars = this.text();
        if (this.ignoreLeadingWhitespace() && indent == 0) {
            chars = chars.substring(BasicTextSegment.indexOfFirstNonWhitespace(chars));
        }
        int wrapIndent = this.computeWrapIndent(renderer);
        int numChars = this.maxChars(chars, maxWidth - indent, maxWidth - wrapIndent, renderer);
        while (chars.length() > numChars) {
            ++lines;
            chars = chars.substring(numChars);
            chars = chars.substring(BasicTextSegment.indexOfFirstNonWhitespace(chars));
            numChars = this.maxChars(chars, maxWidth - wrapIndent, maxWidth - wrapIndent, renderer);
        }
        if (this.isLast()) {
            ++lines;
        }
        return lines * this.lineHeight(renderer);
    }

    public String toString() {
        return this.text();
    }

    protected abstract String text();

    protected boolean ignoreLeadingWhitespace() {
        return true;
    }

    protected int lineHeight(FontRenderer renderer) {
        return Document.lineHeight(renderer);
    }

    protected abstract int stringWidth(String var1, FontRenderer var2);

    protected int maxChars(String s, int maxWidth, int maxLineWidth, FontRenderer renderer) {
        int pos = -1;
        int lastBreak = -1;
        int fullWidth = this.stringWidth(s, renderer);
        while (pos < s.length()) {
            int width;
            boolean exceedsLineLength;
            boolean bl = exceedsLineLength = (width = this.stringWidth(s.substring(0, ++pos), renderer)) >= maxWidth;
            if (exceedsLineLength) {
                boolean matchesFullLine;
                boolean mayUseFullLine = maxWidth == maxLineWidth;
                boolean canFitInLine = fullWidth <= maxLineWidth;
                boolean bl2 = matchesFullLine = fullWidth == maxLineWidth;
                if (lastBreak >= 0) {
                    return lastBreak + 1;
                }
                if (mayUseFullLine && matchesFullLine) {
                    return s.length();
                }
                if (canFitInLine && !mayUseFullLine) {
                    return 0;
                }
                return pos - 1;
            }
            if (pos >= s.length() || !BREAKS.contains(Character.valueOf(s.charAt(pos)))) continue;
            lastBreak = pos;
        }
        return pos;
    }

    protected int computeWrapIndent(FontRenderer renderer) {
        return LISTS.contains(this.getRootPrefix()) ? renderer.func_78256_a(this.getRootPrefix()) : 0;
    }

    private boolean isLast() {
        Segment next = this.next();
        return next == null || this.root() != next.root();
    }

    protected static int indexOfFirstNonWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }
}

