/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import java.net.URI;
import java.util.Optional;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.manual.segment.TextSegment;
import li.cil.tis3d.common.api.ManualAPIImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public final class LinkSegment
extends TextSegment
implements InteractiveSegment {
    private static final int NORMAL_COLOR = 0x333399;
    private static final int NORMAL_COLOR_HOVER = 0x6666CC;
    private static final int ERROR_COLOR = 0x993333;
    private static final int ERROR_COLOR_HOVER = 0xCC6666;
    private static final int FADE_TIME = 500;
    private final String url;
    private boolean isLinkValid;
    private boolean isLinkValidInitialized;
    private long lastHovered = System.currentTimeMillis() - 500L;

    public LinkSegment(Segment parent, String text, String url) {
        super(parent, text);
        this.url = url;
    }

    private boolean isLinkValid() {
        if (!this.isLinkValidInitialized) {
            this.isLinkValid = this.url.startsWith("http://") || this.url.startsWith("https://") || ManualAPI.contentFor(ManualAPIImpl.makeRelative(this.url, ManualAPIImpl.peekPath())) != null;
            this.isLinkValidInitialized = true;
        }
        return this.isLinkValid;
    }

    @Override
    protected Optional<Integer> color() {
        int hoverColor;
        int color;
        if (this.isLinkValid()) {
            color = 0x333399;
            hoverColor = 0x6666CC;
        } else {
            color = 0x993333;
            hoverColor = 0xCC6666;
        }
        int timeSinceHover = (int)(System.currentTimeMillis() - this.lastHovered);
        if (timeSinceHover > 500) {
            return Optional.of(color);
        }
        return Optional.of(LinkSegment.fadeColor(hoverColor, color, (float)timeSinceHover / 500.0f));
    }

    @Override
    public Optional<String> tooltip() {
        return Optional.of(this.url);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        if (this.url.startsWith("http://") || this.url.startsWith("https://")) {
            LinkSegment.handleUrl(this.url);
        } else {
            ManualAPI.navigate(ManualAPIImpl.makeRelative(this.url, ManualAPIImpl.peekPath()));
        }
        return true;
    }

    @Override
    public void notifyHover() {
        this.lastHovered = System.currentTimeMillis();
    }

    private static int fadeColor(int c1, int c2, float t) {
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    private static void handleUrl(String url) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            Object instance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getMethod("browse", URI.class).invoke(instance, new URI(url));
        }
        catch (Throwable t) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(t.toString()));
        }
    }

    @Override
    public String toString() {
        return String.format("[%s](%s)", this.text(), this.url);
    }
}

