/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block;

import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ItemBookManual;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.util.InventoryUtils;
import li.cil.tis3d.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockCasing
extends Block {
    private static final PropertyBool MODULE_X_NEG = PropertyBool.func_177716_a((String)"xneg");
    private static final PropertyBool MODULE_X_POS = PropertyBool.func_177716_a((String)"xpos");
    private static final PropertyBool MODULE_Y_NEG = PropertyBool.func_177716_a((String)"yneg");
    private static final PropertyBool MODULE_Y_POS = PropertyBool.func_177716_a((String)"ypos");
    private static final PropertyBool MODULE_Z_NEG = PropertyBool.func_177716_a((String)"zneg");
    private static final PropertyBool MODULE_Z_POS = PropertyBool.func_177716_a((String)"zpos");

    public BlockCasing() {
        super(Material.field_151573_f);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODULE_X_NEG, MODULE_X_POS, MODULE_Y_NEG, MODULE_Y_POS, MODULE_Z_NEG, MODULE_Z_POS});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = WorldUtils.getTileEntityThreadsafe(world, pos);
        if (!(tileEntity instanceof TileEntityCasing)) {
            return super.func_176221_a(state, world, pos);
        }
        TileEntityCasing casing = (TileEntityCasing)tileEntity;
        return state.func_177226_a((IProperty)MODULE_X_NEG, (Comparable)Boolean.valueOf(casing.getModule(Face.X_NEG) != null)).func_177226_a((IProperty)MODULE_X_POS, (Comparable)Boolean.valueOf(casing.getModule(Face.X_POS) != null)).func_177226_a((IProperty)MODULE_Y_NEG, (Comparable)Boolean.valueOf(casing.getModule(Face.Y_NEG) != null)).func_177226_a((IProperty)MODULE_Y_POS, (Comparable)Boolean.valueOf(casing.getModule(Face.Y_POS) != null)).func_177226_a((IProperty)MODULE_Z_NEG, (Comparable)Boolean.valueOf(casing.getModule(Face.Z_NEG) != null)).func_177226_a((IProperty)MODULE_Z_POS, (Comparable)Boolean.valueOf(casing.getModule(Face.Z_POS) != null));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityCasing casing;
        ItemStack stack;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCasing && !(stack = (casing = (TileEntityCasing)tileEntity).func_70301_a(target.field_178784_b.ordinal())).func_190926_b()) {
            return stack.func_77946_l();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCasing();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.func_175667_e(pos) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityCasing) {
            ItemStack moduleStack;
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (Items.isKey(heldItem)) {
                if (!world.field_72995_K) {
                    if (casing.isLocked()) {
                        casing.unlock(heldItem);
                    } else if (!player.func_70093_af()) {
                        casing.lock(heldItem);
                    } else {
                        Vec3d uv;
                        Port port;
                        Face face;
                        casing.setReceivingPipeLocked(face, port, !casing.isReceivingPipeLocked(face = Face.fromEnumFacing(side), port = Port.fromUVQuadrant(uv = TransformUtil.hitToUV(face, new Vec3d((double)hitX, (double)hitY, (double)hitZ)))));
                    }
                }
                return true;
            }
            if (Items.isBookManual(heldItem) && ItemBookManual.tryOpenManual(world, player, ManualAPI.pathFor(moduleStack = casing.func_70301_a(side.ordinal())))) {
                return true;
            }
            Module module = casing.getModule(Face.fromEnumFacing(side));
            if (module != null && module.onActivate(player, hand, hitX, hitY, hitZ)) {
                return true;
            }
            if (casing.isLocked()) {
                return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
            }
            ItemStack oldModule = casing.func_70301_a(side.ordinal());
            if (!oldModule.func_190926_b()) {
                EntityItem entity;
                if (!world.field_72995_K && (entity = InventoryUtils.drop(world, pos, casing, side.ordinal(), 1, side)) != null) {
                    entity.func_174868_q();
                    entity.func_70100_b_(player);
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                }
                return true;
            }
            if (!heldItem.func_190926_b() && casing.func_180462_a(side.ordinal(), heldItem, side)) {
                if (!world.field_72995_K) {
                    ItemStack insertedStack = player.field_71075_bZ.field_75098_d ? heldItem.func_77946_l().func_77979_a(1) : heldItem.func_77979_a(1);
                    if (side.func_176740_k() == EnumFacing.Axis.Y) {
                        Port orientation = Port.fromEnumFacing(player.func_174811_aO());
                        casing.setInventorySlotContents(side.ordinal(), insertedStack, orientation);
                    } else {
                        casing.func_70299_a(side.ordinal(), insertedStack);
                    }
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityCasing) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityCasing)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCasing casing;
        Module module;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityCasing && (module = (casing = (TileEntityCasing)tileentity).getModule(Face.fromEnumFacing(side.func_176734_d()))) instanceof Redstone) {
            return ((Redstone)module).getRedstoneOutput();
        }
        return super.func_180656_a(blockState, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCasing) {
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            casing.checkNeighbors();
            casing.notifyModulesOfBlockChange(neighborPos);
            casing.markRedstoneDirty();
        }
        super.func_189540_a(state, world, pos, neighborBlock, neighborPos);
    }
}

