/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.API;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.item.ItemBookCode;
import li.cil.tis3d.common.item.ItemBookManual;
import li.cil.tis3d.common.item.ItemKey;
import li.cil.tis3d.common.item.ItemModule;
import li.cil.tis3d.common.item.ItemModuleReadOnlyMemory;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@GameRegistry.ObjectHolder(value="tis3d")
public final class Items {
    private static final Map<String, Item> modules = new HashMap<String, Item>();
    @GameRegistry.ObjectHolder(value="book_code")
    public static final Item bookCode = null;
    @GameRegistry.ObjectHolder(value="book_manual")
    public static final Item bookManual = null;
    @GameRegistry.ObjectHolder(value="key")
    public static final Item key = null;
    @GameRegistry.ObjectHolder(value="key_creative")
    public static final Item keyCreative = null;
    @GameRegistry.ObjectHolder(value="prism")
    public static final Item prism = null;

    public static Map<String, Item> getModules() {
        return modules;
    }

    public static List<Item> getAllItems() {
        ArrayList<Item> result = new ArrayList<Item>(modules.values());
        result.addAll(Arrays.asList(bookCode, bookManual, key, keyCreative, prism, Item.func_150898_a((Block)Blocks.casing), Item.func_150898_a((Block)Blocks.controller)));
        return result;
    }

    public static boolean isItem(ItemStack stack, @Nullable Item item) {
        return !stack.func_190926_b() && stack.func_77973_b() == item;
    }

    public static boolean isBookCode(ItemStack stack) {
        return Items.isItem(stack, bookCode);
    }

    public static boolean isBookManual(ItemStack stack) {
        return Items.isItem(stack, bookManual);
    }

    public static boolean isKey(ItemStack stack) {
        return Items.isItem(stack, key) || Items.isKeyCreative(stack);
    }

    public static boolean isKeyCreative(ItemStack stack) {
        return Items.isItem(stack, keyCreative);
    }

    public static boolean isModuleReadOnlyMemory(ItemStack stack) {
        return Items.isItem(stack, modules.get("module_read_only_memory"));
    }

    public static void register(IForgeRegistry<Item> registry) {
        for (String moduleName : Constants.MODULES) {
            Item module = Items.registerModule(registry, moduleName);
            if (module == null) continue;
            modules.put(moduleName, module);
        }
        Items.registerItem(registry, (Item)new ItemBookCode(), "book_code");
        Items.registerItem(registry, (Item)new ItemBookManual(), "book_manual");
        Items.registerItem(registry, new ItemKey(), "key");
        Items.registerItem(registry, new ItemKey(), "key_creative");
        Items.registerItem(registry, new Item(), "prism");
        for (Block block : Blocks.getAllBlocks()) {
            Items.registerItem(registry, (Item)new ItemBlock(block), block.getRegistryName().func_110623_a());
        }
    }

    private static Item registerItem(IForgeRegistry<Item> registry, Item item, String name) {
        registry.register(item.func_77655_b("tis3d." + name).func_77637_a((CreativeTabs)API.creativeTab).setRegistryName(name));
        return item;
    }

    @Nullable
    private static Item registerModule(IForgeRegistry<Item> registry, String name) {
        if (Settings.disabledModules.contains(name)) {
            return null;
        }
        if (Objects.equals(name, "module_read_only_memory")) {
            return Items.registerItem(registry, new ItemModuleReadOnlyMemory(), name);
        }
        return Items.registerItem(registry, new ItemModule(), name);
    }

    private Items() {
    }
}

