/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.charset;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.integration.charset.CapabilityBundledEmitter;
import li.cil.tis3d.common.integration.charset.CapabilityBundledReceiver;
import li.cil.tis3d.common.integration.charset.CapabilityRedstoneEmitter;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneEmitter;

public final class CallbacksCharsetWires {
    public static void register() {
        RedstoneIntegration.INSTANCE.addCallback(CallbacksCharsetWires::onBundledOutputChanged);
        RedstoneIntegration.INSTANCE.addRedstoneInputProvider(CallbacksCharsetWires::getInput);
        RedstoneIntegration.INSTANCE.addBundledRedstoneInputProvider(CallbacksCharsetWires::getBundledInput);
    }

    public static void onBundledOutputChanged(BundledRedstone module, int channel) {
        IBundledReceiver receiver;
        TileEntity tileEntity;
        BlockPos neighborPos;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_175667_e(neighborPos = module.getCasing().getPosition().func_177972_a(facing)) && (tileEntity = world.func_175625_s(neighborPos)) != null && tileEntity.hasCapability(CapabilityBundledReceiver.INSTANCE, facing.func_176734_d()) && (receiver = (IBundledReceiver)tileEntity.getCapability(CapabilityBundledReceiver.INSTANCE, facing.func_176734_d())) != null) {
            receiver.onBundledInputChange();
        }
    }

    public static int getInput(Redstone module) {
        IRedstoneEmitter emitter;
        TileEntity tileEntity;
        BlockPos inputPos;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_175667_e(inputPos = module.getCasing().getPosition().func_177972_a(facing)) && (tileEntity = world.func_175625_s(inputPos)) != null && tileEntity.hasCapability(CapabilityRedstoneEmitter.INSTANCE, facing.func_176734_d()) && (emitter = (IRedstoneEmitter)tileEntity.getCapability(CapabilityRedstoneEmitter.INSTANCE, facing.func_176734_d())) != null) {
            return emitter.getRedstoneSignal() & 0xFFFF;
        }
        return 0;
    }

    public static int getBundledInput(BundledRedstone module, int channel) {
        IBundledEmitter emitter;
        TileEntity tileEntity;
        BlockPos inputPos;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_175667_e(inputPos = module.getCasing().getPosition().func_177972_a(facing)) && (tileEntity = world.func_175625_s(inputPos)) != null && tileEntity.hasCapability(CapabilityBundledEmitter.INSTANCE, facing.func_176734_d()) && (emitter = (IBundledEmitter)tileEntity.getCapability(CapabilityBundledEmitter.INSTANCE, facing.func_176734_d())) != null) {
            return emitter.getBundledSignal()[channel];
        }
        return 0;
    }

    private CallbacksCharsetWires() {
    }
}

