/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.common.inventory.Inventory;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageCasingInventory;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class InventoryCasing
extends Inventory
implements ISidedInventory {
    private final TileEntityCasing tileEntity;

    public InventoryCasing(TileEntityCasing tileEntity) {
        super("container.casing", Face.VALUES.length);
        this.tileEntity = tileEntity;
    }

    public void setInventorySlotContents(int index, ItemStack stack, Port facing) {
        if (this.items[index] == stack) {
            return;
        }
        if (!this.items[index].func_190926_b()) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (!this.items[index].func_190926_b()) {
            this.onItemAdded(index, facing);
        }
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70296_d() {
        this.tileEntity.func_70296_d();
        if (this.tileEntity.func_145830_o() && this.tileEntity.func_145831_w().field_72995_K) {
            IBlockState state = this.tileEntity.func_145831_w().func_180495_p(this.tileEntity.func_174877_v());
            this.tileEntity.func_145831_w().func_184138_a(this.tileEntity.func_174877_v(), state, state, 1);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[side.ordinal()];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        return side.ordinal() == index && this.func_70301_a(index).func_190926_b() && this.tileEntity.getModule(Face.fromEnumFacing(side)) == null && this.canInstall(stack, Face.fromEnumFacing(side));
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side.ordinal() == index && stack == this.func_70301_a(index);
    }

    private boolean canInstall(ItemStack stack, Face face) {
        return ModuleAPI.getProviderFor(stack, this.tileEntity, face) != null;
    }

    @Override
    protected void onItemAdded(int index) {
        this.onItemAdded(index, Port.UP);
    }

    private void onItemAdded(int index, Port facing) {
        ItemStack stack = this.func_70301_a(index);
        if (stack.func_190926_b()) {
            return;
        }
        Face face = Face.VALUES[index];
        ModuleProvider provider = ModuleAPI.getProviderFor(stack, this.tileEntity, face);
        if (provider == null) {
            return;
        }
        Module module = provider.createModule(stack, this.tileEntity, face);
        if (module instanceof Rotatable) {
            ((Rotatable)module).setFacing(facing);
        }
        if (!this.tileEntity.getCasingWorld().field_72995_K) {
            NBTTagCompound moduleData;
            if (module != null) {
                module.onInstalled(stack);
                moduleData = new NBTTagCompound();
                module.writeToNBT(moduleData);
            } else {
                moduleData = null;
            }
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageCasingInventory(this.tileEntity, index, stack, moduleData), Network.getTargetPoint(this.tileEntity, 48));
        }
        this.tileEntity.setModule(Face.VALUES[index], module);
    }

    @Override
    protected void onItemRemoved(int index) {
        Face face = Face.VALUES[index];
        Module module = this.tileEntity.getModule(face);
        this.tileEntity.setModule(face, null);
        if (!this.tileEntity.getCasingWorld().field_72995_K) {
            if (module != null) {
                module.onUninstalled(this.func_70301_a(index));
                module.onDisposed();
            }
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageCasingInventory(this.tileEntity, index, ItemStack.field_190927_a, null), Network.getTargetPoint(this.tileEntity, 48));
        }
    }
}

