/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.BundledRedstoneOutputChangedEvent;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.util.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModuleBundledRedstone
extends AbstractModuleRotatable
implements BundledRedstone {
    private final short[] output = new short[16];
    private final short[] input = new short[16];
    private short channel = 0;
    private static final String TAG_OUTPUT = "output";
    private static final String TAG_INPUT = "input";
    private static final String TAG_CHANNEL = "channel";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final float LEFT_U0 = 0.25f;
    private static final float RIGHT_U0 = 0.625f;
    private static final float SHARED_V0 = 0.3125f;
    private static final float V_STEP = 0.0625f;
    private long lastStep = 0L;
    private boolean scheduledNeighborUpdate = false;

    public ModuleBundledRedstone(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
            this.stepInput(port);
        }
        if (this.scheduledNeighborUpdate && world.func_82737_E() > this.lastStep) {
            this.notifyNeighbors();
        }
        this.lastStep = world.func_82737_E();
    }

    @Override
    public void onDisabled() {
        Arrays.fill(this.input, (short)0);
        Arrays.fill(this.output, (short)0);
        this.channel = 0;
        BundledRedstoneOutputChangedEvent event = new BundledRedstoneOutputChangedEvent(this, -1);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.sendData();
    }

    @Override
    public void onEnabled() {
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    public void onData(ByteBuf data) {
        int i;
        for (i = 0; i < this.input.length; ++i) {
            this.input[i] = data.readShort();
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i] = data.readShort();
        }
        this.channel = data.readShort();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_BUNDLED_REDSTONE));
        if (!enabled) {
            return;
        }
        this.renderBar(this.output, 0.25f);
        this.renderBar(this.input, 0.625f);
        GlStateManager.func_179090_x();
        int color = ColorUtils.getColorByIndex(this.channel);
        GlStateManager.func_179124_c((float)ColorUtils.getRed(color), (float)ColorUtils.getGreen(color), (float)ColorUtils.getBlue(color));
        RenderUtil.drawUntexturedQuad(0.4375f, 0.4375f, 0.125f, 0.125f);
        GlStateManager.func_179098_w();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        int[] outputNbt = nbt.func_74759_k(TAG_OUTPUT);
        for (int i = 0; i < outputNbt.length; ++i) {
            this.output[i] = (short)outputNbt[i];
        }
        int[] inputNbt = nbt.func_74759_k(TAG_INPUT);
        for (int i = 0; i < inputNbt.length; ++i) {
            this.input[i] = (short)inputNbt[i];
        }
        this.channel = (short)Math.max(0, Math.min(this.input.length - 1, nbt.func_74765_d(TAG_CHANNEL)));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int[] outputNbt = new int[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            outputNbt[i] = this.output[i];
        }
        nbt.func_74783_a(TAG_OUTPUT, outputNbt);
        int[] inputNbt = new int[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            inputNbt[i] = this.input[i];
        }
        nbt.func_74783_a(TAG_INPUT, inputNbt);
        nbt.func_74777_a(TAG_CHANNEL, this.channel);
    }

    @Override
    public int getBundledRedstoneOutput(int channel) {
        return this.output[channel];
    }

    @Override
    public void setBundledRedstoneInput(int channel, short value) {
        World world = this.getCasing().getCasingWorld();
        if (world.field_72995_K) {
            return;
        }
        if (value == this.input[channel]) {
            return;
        }
        this.input[channel] = value;
        this.getCasing().markDirty();
        this.cancelWrite();
        this.sendData();
    }

    @Override
    public short getBundledRedstoneInput(int channel) {
        return this.input[channel];
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.input[this.channel]);
        }
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.process(receivingPipe.read());
        }
    }

    private void process(int value) {
        short hi = (short)((value & 0xFF00) >>> 8);
        short lo = (short)(value & 0xFF);
        if (hi == 255) {
            if (lo < 0 || lo >= this.input.length) {
                return;
            }
            if (lo != this.channel) {
                this.channel = lo;
                this.cancelWrite();
                this.sendData();
            }
        } else {
            this.setRedstoneOutput(hi, lo);
        }
    }

    private void setRedstoneOutput(int channel, short value) {
        if (channel < 0 || channel >= this.output.length) {
            return;
        }
        if (value == this.output[channel]) {
            return;
        }
        this.output[channel] = value;
        this.getCasing().markDirty();
        this.scheduledNeighborUpdate = true;
        BundledRedstoneOutputChangedEvent event = new BundledRedstoneOutputChangedEvent(this, channel);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.sendData();
    }

    private void notifyNeighbors() {
        World world = this.getCasing().getCasingWorld();
        this.scheduledNeighborUpdate = false;
        Block blockType = world.func_180495_p(this.getCasing().getPosition()).func_177230_c();
        world.func_175685_c(this.getCasing().getPosition(), blockType, false);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        for (short value : this.input) {
            data.writeShort((int)value);
        }
        for (short value : this.output) {
            data.writeShort((int)value);
        }
        data.writeShort((int)this.channel);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBar(short[] values, float u) {
        GlStateManager.func_179090_x();
        for (int channel = 0; channel < values.length; ++channel) {
            if (values[channel] <= 0) continue;
            int color = ColorUtils.getColorByIndex(channel);
            GlStateManager.func_179124_c((float)ColorUtils.getRed(color), (float)ColorUtils.getGreen(color), (float)ColorUtils.getBlue(color));
            float u0 = u + (float)(channel & 1) * 0.0625f;
            float v0 = 0.3125f + (float)(channel >> 1) * 0.0625f;
            RenderUtil.drawUntexturedQuad(u0, v0, 0.0625f, 0.0625f);
        }
        GlStateManager.func_179098_w();
    }
}

