/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.client.network.handler.MessageHandlerCasingEnabledState;
import li.cil.tis3d.client.network.handler.MessageHandlerCasingInventory;
import li.cil.tis3d.client.network.handler.MessageHandlerCasingLockedState;
import li.cil.tis3d.client.network.handler.MessageHandlerHaltAndCatchFire;
import li.cil.tis3d.client.network.handler.MessageHandlerModuleReadOnlyMemoryDataClient;
import li.cil.tis3d.client.network.handler.MessageHandlerParticleEffects;
import li.cil.tis3d.client.network.handler.MessageHandlerReceivingPipeLockedState;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.network.handler.MessageHandlerBookCodeData;
import li.cil.tis3d.common.network.handler.MessageHandlerCasingData;
import li.cil.tis3d.common.network.handler.MessageHandlerModuleReadOnlyMemoryDataServer;
import li.cil.tis3d.common.network.message.MessageBookCodeData;
import li.cil.tis3d.common.network.message.MessageCasingData;
import li.cil.tis3d.common.network.message.MessageCasingEnabledState;
import li.cil.tis3d.common.network.message.MessageCasingInventory;
import li.cil.tis3d.common.network.message.MessageCasingLockedState;
import li.cil.tis3d.common.network.message.MessageHaltAndCatchFire;
import li.cil.tis3d.common.network.message.MessageModuleReadOnlyMemoryData;
import li.cil.tis3d.common.network.message.MessageParticleEffect;
import li.cil.tis3d.common.network.message.MessageReceivingPipeLockedState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class Network {
    public static final Network INSTANCE = new Network();
    public static final int RANGE_HIGH = 48;
    public static final int RANGE_MEDIUM = 32;
    public static final int RANGE_LOW = 16;
    private static SimpleNetworkWrapper wrapper;
    private static final int TICK_TIME = 50;
    private static final Set<Position> particleQueue;
    private static long lastParticlesSent;
    private static int particlesSent;
    private static int particleSendInterval;
    private static int packetsSentServer;
    private static int packetsSentClient;
    private static int throttleServer;
    private static int throttleClient;
    private static final Stack<CasingSendQueue> queuePool;
    private static final Map<Casing, CasingSendQueue> clientQueues;
    private static final Map<Casing, CasingSendQueue> serverQueues;

    public void init() {
        wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("tis3d");
        wrapper.registerMessage(MessageHandlerBookCodeData.class, MessageBookCodeData.class, Messages.BookCodeData.ordinal(), Side.SERVER);
        wrapper.registerMessage(MessageHandlerCasingData.class, MessageCasingData.class, Messages.CasingDataClient.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerCasingData.class, MessageCasingData.class, Messages.CasingDataServer.ordinal(), Side.SERVER);
        wrapper.registerMessage(MessageHandlerCasingEnabledState.class, MessageCasingEnabledState.class, Messages.CasingEnabledState.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerCasingLockedState.class, MessageCasingLockedState.class, Messages.CasingLockedState.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerCasingInventory.class, MessageCasingInventory.class, Messages.CasingInventory.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerHaltAndCatchFire.class, MessageHaltAndCatchFire.class, Messages.HaltAndCatchFire.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerParticleEffects.class, MessageParticleEffect.class, Messages.ParticleEffects.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerReceivingPipeLockedState.class, MessageReceivingPipeLockedState.class, Messages.ReceivingPipeLockedState.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerModuleReadOnlyMemoryDataClient.class, MessageModuleReadOnlyMemoryData.class, Messages.ReadOnlyMemoryData.ordinal(), Side.CLIENT);
        wrapper.registerMessage(MessageHandlerModuleReadOnlyMemoryDataServer.class, MessageModuleReadOnlyMemoryData.class, Messages.ReadOnlyMemoryData.ordinal(), Side.SERVER);
    }

    public SimpleNetworkWrapper getWrapper() {
        return wrapper;
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(World world, double x, double y, double z, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, (double)range);
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(World world, BlockPos position, int range) {
        return Network.getTargetPoint(world, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, range);
    }

    public static NetworkRegistry.TargetPoint getTargetPoint(TileEntity tileEntity, int range) {
        return Network.getTargetPoint(tileEntity.func_145831_w(), tileEntity.func_174877_v(), range);
    }

    public static void sendModuleData(Casing casing, Face face, NBTTagCompound data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public static void sendModuleData(Casing casing, Face face, ByteBuf data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public static void sendPipeEffect(World world, double x, double y, double z) {
        IBlockState state;
        BlockPos position = new BlockPos(x, y, z);
        if (!world.func_175667_e(position) && (state = world.func_180495_p(position)).func_185917_h()) {
            return;
        }
        Network.queueParticleEffect(world, (float)x, (float)y, (float)z);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.getPhase() == EventPriority.NORMAL) {
            Network.flushCasingQueues(Side.SERVER);
            Network.flushParticleQueue();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.type == TickEvent.Type.CLIENT && event.getPhase() == EventPriority.NORMAL) {
            Network.flushCasingQueues(Side.CLIENT);
        }
    }

    private static void queueParticleEffect(World world, float x, float y, float z) {
        Position position = new Position(world, x, y, z);
        particleQueue.add(position);
    }

    private static void flushParticleQueue() {
        long now = System.currentTimeMillis();
        if (now - lastParticlesSent < (long)particleSendInterval) {
            return;
        }
        lastParticlesSent = now;
        particlesSent = 0;
        particleQueue.forEach(rec$ -> ((Position)rec$).sendMessage());
        if (particlesSent > Settings.maxParticlesPerTick) {
            int throttle = (int)Math.ceil((float)particlesSent / (float)Settings.maxParticlesPerTick);
            particleSendInterval = Math.min(2000, 50 * throttle);
        } else {
            particleSendInterval = 50;
        }
        particleQueue.clear();
    }

    private static int getPacketsSent(Side side) {
        return side == Side.CLIENT ? packetsSentClient : packetsSentServer;
    }

    private static void resetPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            packetsSentClient = 0;
        } else {
            packetsSentServer = 0;
        }
    }

    private static void incrementPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            ++packetsSentClient;
        } else {
            ++packetsSentServer;
        }
    }

    private static int getThrottle(Side side) {
        return side == Side.CLIENT ? throttleClient : throttleServer;
    }

    private static void setThrottle(Side side, int value) {
        if (side == Side.CLIENT) {
            throttleClient = value;
        } else {
            throttleServer = value;
        }
    }

    private static void decrementThrottle(Side side) {
        if (side == Side.CLIENT) {
            --throttleClient;
        } else {
            --throttleServer;
        }
    }

    private static Map<Casing, CasingSendQueue> getQueues(Side side) {
        if (side == Side.CLIENT) {
            return clientQueues;
        }
        return serverQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CasingSendQueue getQueueFor(Casing casing) {
        World world = casing.getCasingWorld();
        Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        Map<Casing, CasingSendQueue> queues = Network.getQueues(side);
        CasingSendQueue queue = queues.get(casing);
        if (queue == null) {
            Stack<CasingSendQueue> stack = queuePool;
            synchronized (stack) {
                queue = queuePool.size() > 0 ? queuePool.pop() : new CasingSendQueue();
            }
            queues.put(casing, queue);
        }
        return queue;
    }

    private static void flushCasingQueues(Side side) {
        if (Network.getThrottle(side) > 0) {
            Network.decrementThrottle(side);
            return;
        }
        Network.resetPacketsSent(side);
        Map<Casing, CasingSendQueue> queues = Network.getQueues(side);
        queues.forEach(Network::flushCasingQueue);
        Network.clearQueues(queues);
        int sent = Network.getPacketsSent(side);
        if (sent > Settings.maxPacketsPerTick) {
            int throttle = (int)Math.min(40.0, Math.ceil((float)sent / (float)Settings.maxPacketsPerTick));
            Network.setThrottle(side, throttle);
        }
    }

    private static void flushCasingQueue(Casing casing, CasingSendQueue queue) {
        queue.flush(casing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearQueues(Map<Casing, CasingSendQueue> queues) {
        Stack<CasingSendQueue> stack = queuePool;
        synchronized (stack) {
            queuePool.addAll(queues.values());
        }
        queues.clear();
    }

    private static boolean areAnyPlayersNear(NetworkRegistry.TargetPoint target) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            NetworkDispatcher dispatcher;
            double dz;
            double dy;
            double dx;
            if (player.field_71093_bK != target.dimension || player.field_71135_a == null || !((dx = target.x - player.field_70165_t) * dx + (dy = target.y - player.field_70163_u) * dy + (dz = target.z - player.field_70161_v) * dz < target.range * target.range) || (dispatcher = (NetworkDispatcher)player.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get()) == null) continue;
            return true;
        }
        return false;
    }

    private Network() {
    }

    static {
        particleQueue = new HashSet<Position>();
        lastParticlesSent = 0L;
        particlesSent = 0;
        particleSendInterval = 50;
        packetsSentServer = 0;
        packetsSentClient = 0;
        throttleServer = 0;
        throttleClient = 0;
        queuePool = new Stack();
        clientQueues = new HashMap<Casing, CasingSendQueue>();
        serverQueues = new HashMap<Casing, CasingSendQueue>();
    }

    private static final class ModuleSendQueue {
        private final List<QueueEntry> sendQueue = new ArrayList<QueueEntry>();
        private final BitSet sentTypes = new BitSet(255);

        private ModuleSendQueue() {
        }

        private void queueData(NBTTagCompound data, byte type) {
            this.sendQueue.add(new QueueEntryNBT(type, data));
        }

        private void queueData(ByteBuf data, byte type) {
            this.sendQueue.add(new QueueEntryByteBuf(type, data));
        }

        private ByteBuf collectData() {
            int i;
            ByteBuf data = Unpooled.buffer();
            int firstToWrite = this.sendQueue.size();
            for (i = this.sendQueue.size() - 1; i >= 0; --i) {
                byte type = this.sendQueue.get((int)i).type;
                if (type >= 0) {
                    if (this.sentTypes.get(type)) continue;
                    this.sentTypes.set(type);
                }
                this.sendQueue.add(this.sendQueue.get(i));
            }
            for (i = this.sendQueue.size() - 1; i >= firstToWrite; --i) {
                this.sendQueue.get(i).write(data);
            }
            this.sendQueue.clear();
            this.sentTypes.clear();
            return data;
        }

        private static final class QueueEntryByteBuf
        extends QueueEntry {
            public final ByteBuf data;

            private QueueEntryByteBuf(byte type, ByteBuf data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                if (this.data.readableBytes() > 0) {
                    buffer.writeBoolean(false);
                    ByteBufUtils.writeVarShort((ByteBuf)buffer, (int)this.data.readableBytes());
                    buffer.writeBytes(this.data);
                }
            }
        }

        private static final class QueueEntryNBT
        extends QueueEntry {
            public final NBTTagCompound data;

            private QueueEntryNBT(byte type, NBTTagCompound data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                ByteBuf data = Unpooled.buffer();
                ByteBufOutputStream bos = new ByteBufOutputStream(data);
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)bos);
                    if (data.readableBytes() > 0) {
                        buffer.writeBoolean(true);
                        ByteBufUtils.writeVarShort((ByteBuf)buffer, (int)data.readableBytes());
                        buffer.writeBytes(data);
                    }
                }
                catch (IOException e) {
                    TIS3D.getLog().warn("Failed sending packet.", (Throwable)e);
                }
            }
        }

        private static abstract class QueueEntry {
            public final byte type;

            private QueueEntry(byte type) {
                this.type = type;
            }

            public abstract void write(ByteBuf var1);
        }
    }

    private static final class CasingSendQueue {
        private final ModuleSendQueue[] moduleQueues = new ModuleSendQueue[Face.VALUES.length];

        private CasingSendQueue() {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                this.moduleQueues[i] = new ModuleSendQueue();
            }
        }

        private void queueData(Face face, NBTTagCompound data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void queueData(Face face, ByteBuf data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void flush(Casing casing) {
            World world = casing.getCasingWorld();
            Side side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
            ByteBuf data = Unpooled.buffer();
            this.collectData(data);
            if (data.readableBytes() > 0) {
                boolean didSend;
                MessageCasingData message = new MessageCasingData(casing, data);
                if (side == Side.CLIENT) {
                    INSTANCE.getWrapper().sendToServer((IMessage)message);
                    didSend = true;
                } else {
                    NetworkRegistry.TargetPoint point = Network.getTargetPoint(casing.getCasingWorld(), casing.getPosition(), 48);
                    INSTANCE.getWrapper().sendToAllAround((IMessage)message, point);
                    didSend = Network.areAnyPlayersNear(point);
                }
                if (didSend) {
                    Network.incrementPacketsSent(side);
                }
            }
        }

        private void collectData(ByteBuf data) {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                ByteBuf moduleData = this.moduleQueues[i].collectData();
                if (moduleData.readableBytes() <= 0) continue;
                data.writeByte(i);
                ByteBufUtils.writeVarShort((ByteBuf)data, (int)moduleData.readableBytes());
                data.writeBytes(moduleData);
            }
        }
    }

    private static final class Position {
        private final World world;
        private final float x;
        private final float y;
        private final float z;

        private Position(World world, float x, float y, float z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void sendMessage() {
            MessageParticleEffect message = new MessageParticleEffect(this.world, EnumParticleTypes.REDSTONE, this.x, this.y, this.z);
            NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)this.x, (double)this.y, (double)this.z, 16.0);
            INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
            if (Network.areAnyPlayersNear(target)) {
                particlesSent++;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Position that = (Position)obj;
            return this.world.field_73011_w.getDimension() == that.world.field_73011_w.getDimension() && Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && Float.compare(that.z, this.z) == 0;
        }

        public int hashCode() {
            int result = this.world.field_73011_w.getDimension();
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
            return result;
        }
    }

    private static enum Messages {
        CasingDataClient,
        CasingDataServer,
        ParticleEffects,
        CasingEnabledState,
        BookCodeData,
        HaltAndCatchFire,
        CasingLockedState,
        ReceivingPipeLockedState,
        CasingInventory,
        ReadOnlyMemoryData;

    }
}

