/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.network.handler.AbstractMessageHandlerWithLocation;
import li.cil.tis3d.common.network.message.MessageCasingData;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class MessageHandlerCasingData
extends AbstractMessageHandlerWithLocation<MessageCasingData> {
    @Override
    protected void onMessageSynchronized(MessageCasingData message, MessageContext context) {
        TileEntity tileEntity = this.getTileEntity(message, context);
        if (!(tileEntity instanceof TileEntityCasing)) {
            return;
        }
        TileEntityCasing casing = (TileEntityCasing)tileEntity;
        ByteBuf data = message.getData();
        while (data.readableBytes() > 0) {
            Module module = casing.getModule(Face.VALUES[data.readByte()]);
            ByteBuf moduleData = data.readBytes(ByteBufUtils.readVarShort((ByteBuf)data));
            while (moduleData.readableBytes() > 0) {
                boolean isNbt = moduleData.readBoolean();
                ByteBuf packet = moduleData.readBytes(ByteBufUtils.readVarShort((ByteBuf)moduleData));
                if (module == null) continue;
                if (isNbt) {
                    try {
                        ByteBufInputStream bis = new ByteBufInputStream(packet);
                        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)bis);
                        module.onData(nbt);
                    }
                    catch (IOException e) {
                        TIS3D.getLog().warn("Invalid packet received.", (Throwable)e);
                    }
                    continue;
                }
                module.onData(packet);
            }
        }
    }
}

