/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import li.cil.tis3d.common.inventory.InventoryCasing;
import li.cil.tis3d.common.inventory.SidedInventoryProxy;
import li.cil.tis3d.common.machine.CasingImpl;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageCasingEnabledState;
import li.cil.tis3d.common.network.message.MessageCasingLockedState;
import li.cil.tis3d.common.network.message.MessageReceivingPipeLockedState;
import li.cil.tis3d.common.tileentity.TileEntityComputer;
import li.cil.tis3d.common.tileentity.TileEntityController;
import li.cil.tis3d.util.InventoryUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class TileEntityCasing
extends TileEntityComputer
implements SidedInventoryProxy,
CasingProxy {
    private final InventoryCasing inventory = new InventoryCasing(this);
    private final CasingImpl casing = new CasingImpl(this);
    private final boolean[][] locked = new boolean[6][4];
    private static final String TAG_CASING = "casing";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_LOCKED = "closed";
    private TileEntityController controller;
    private boolean isEnabled;
    private boolean redstoneDirty = true;

    public boolean isCasingEnabled() {
        return this.isEnabled;
    }

    public void markRedstoneDirty() {
        this.redstoneDirty = true;
    }

    public void setReceivingPipeLocked(Face face, Port port, boolean value) {
        if (this.isReceivingPipeLocked(face, port) != value) {
            this.getReceivingPipe(face, port).cancelRead();
            this.locked[face.ordinal()][port.ordinal()] = value;
            this.sendReceivingPipeLockedState(face, port);
        }
    }

    public boolean isReceivingPipeLocked(Face face, Port port) {
        return this.locked[face.ordinal()][port.ordinal()];
    }

    public void setInventorySlotContents(int index, ItemStack stack, Port facing) {
        this.inventory.setInventorySlotContents(index, stack, facing);
    }

    @Nullable
    public TileEntityController getController() {
        return this.controller;
    }

    public void setController(@Nullable TileEntityController controller) {
        this.controller = controller;
    }

    @Override
    public void scheduleScan() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.getController() != null) {
            this.getController().scheduleScan();
        } else {
            TileEntityController controller = this.findController();
            if (controller != null) {
                controller.scheduleScan();
            }
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        this.casing.setModule(face, module);
    }

    public void lock(ItemStack stack) {
        this.casing.lock(stack);
        this.sendCasingLockedState();
    }

    public void unlock(ItemStack stack) {
        if (this.casing.unlock(stack)) {
            this.sendCasingLockedState();
        }
    }

    public void notifyModulesOfBlockChange(BlockPos neighborPos) {
        for (Face face : Face.VALUES) {
            Module module = this.getModule(face);
            if (!(module instanceof BlockChangeAware)) continue;
            BlockPos moduleNeighborPos = this.getPosition().func_177972_a(Face.toEnumFacing(face));
            boolean isModuleNeighbor = Objects.equals(neighborPos, moduleNeighborPos);
            ((BlockChangeAware)module).onNeighborBlockChange(neighborPos, isModuleNeighbor);
        }
    }

    void onEnabled() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.sendState();
        this.casing.onEnabled();
    }

    void onDisabled() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.sendState();
        this.casing.onDisabled();
    }

    void stepRedstone() {
        if (!this.redstoneDirty) {
            return;
        }
        this.redstoneDirty = false;
        for (Face face : Face.VALUES) {
            Module module = this.getCasing().getModule(face);
            if (module instanceof Redstone) {
                Redstone redstone = (Redstone)module;
                short signal = (short)RedstoneIntegration.INSTANCE.getRedstoneInput(redstone);
                redstone.setRedstoneInput(signal);
            }
            if (!(module instanceof BundledRedstone)) continue;
            BundledRedstone bundledRedstone = (BundledRedstone)module;
            for (int channel = 0; channel < 16; ++channel) {
                short signal = (short)RedstoneIntegration.INSTANCE.getBundledRedstoneInput(bundledRedstone, channel);
                bundledRedstone.setBundledRedstoneInput(channel, signal);
            }
        }
    }

    void stepModules() {
        this.casing.stepModules();
    }

    @Override
    protected void setNeighbor(Face face, @Nullable TileEntityComputer neighbor) {
        super.setNeighbor(face, neighbor);
        if (this.hasNeighbor(face)) {
            InventoryUtils.drop(this.func_145831_w(), this.func_174877_v(), this, face.ordinal(), this.func_70297_j_(), Face.toEnumFacing(face));
        }
        if (neighbor instanceof TileEntityController && this.getController() != neighbor && this.getController() != null) {
            this.getController().scheduleScan();
        }
    }

    @Override
    public void onBeforeWriteComplete(Face sendingFace, Port sendingPort) {
        super.onBeforeWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onBeforeWriteComplete(sendingPort);
        }
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
        super.onWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onWriteComplete(sendingPort);
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double maxDistance = 64.0;
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    @Override
    public ISidedInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K) {
            this.onDisabled();
        }
        this.dispose();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dispose();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (facing == null) {
            return false;
        }
        Module module = this.getModule(Face.fromEnumFacing(facing));
        if (module instanceof ICapabilityProvider) {
            ICapabilityProvider capabilityProvider = (ICapabilityProvider)module;
            return capabilityProvider.hasCapability(capability, facing);
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object instance = super.getCapability(capability, facing);
        if (instance != null) {
            return (T)instance;
        }
        if (facing == null) {
            return null;
        }
        Module module = this.getModule(Face.fromEnumFacing(facing));
        if (module instanceof ICapabilityProvider) {
            ICapabilityProvider capabilityProvider = (ICapabilityProvider)module;
            return (T)capabilityProvider.getCapability(capability, facing);
        }
        return null;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public double func_145833_n() {
        return 2304.0;
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.isReceivingPipeLocked(face, port) ? LockedPipe.INSTANCE : super.getReceivingPipe(face, port);
    }

    @Override
    protected void readFromNBTForClient(NBTTagCompound nbt) {
        super.readFromNBTForClient(nbt);
        this.isEnabled = nbt.func_74767_n(TAG_ENABLED);
    }

    @Override
    protected void writeToNBTForClient(NBTTagCompound nbt) {
        super.writeToNBTForClient(nbt);
        nbt.func_74757_a(TAG_ENABLED, this.isEnabled);
    }

    @Override
    protected void readFromNBTCommon(NBTTagCompound nbt) {
        super.readFromNBTCommon(nbt);
        TileEntityCasing.decompressClosed(nbt.func_74770_j(TAG_LOCKED), this.locked);
        NBTTagCompound inventoryNbt = nbt.func_74775_l(TAG_INVENTORY);
        this.inventory.readFromNBT(inventoryNbt);
        NBTTagCompound casingNbt = nbt.func_74775_l(TAG_CASING);
        this.casing.readFromNBT(casingNbt);
    }

    @Override
    protected void writeToNBTCommon(NBTTagCompound nbt) {
        super.writeToNBTCommon(nbt);
        nbt.func_74773_a(TAG_LOCKED, TileEntityCasing.compressClosed(this.locked));
        NBTTagCompound inventoryNbt = new NBTTagCompound();
        this.inventory.writeToNBT(inventoryNbt);
        nbt.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryNbt);
        NBTTagCompound casingNbt = new NBTTagCompound();
        this.casing.writeToNBT(casingNbt);
        nbt.func_74782_a(TAG_CASING, (NBTBase)casingNbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void setCasingLockedClient(boolean locked) {
        this.casing.setLocked(locked);
    }

    @SideOnly(value=Side.CLIENT)
    public void setStackAndModuleClient(int slot, ItemStack stack, NBTTagCompound moduleData) {
        this.inventory.func_70299_a(slot, stack);
        Module module = this.casing.getModule(Face.VALUES[slot]);
        if (module != null) {
            module.readFromNBT(moduleData);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setEnabledClient(boolean value) {
        this.isEnabled = value;
    }

    @SideOnly(value=Side.CLIENT)
    public void setReceivingPipeLockedClient(Face face, Port port, boolean value) {
        this.locked[face.ordinal()][port.ordinal()] = value;
    }

    @Nullable
    private TileEntityController findController() {
        HashSet<TileEntity> processed = new HashSet<TileEntity>();
        ArrayDeque<TileEntity> queue = new ArrayDeque<TileEntity>();
        int casings = 0;
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            TileEntity tileEntity = (TileEntity)queue.remove();
            if (tileEntity.func_145837_r()) continue;
            if (tileEntity instanceof TileEntityController) {
                return (TileEntityController)tileEntity;
            }
            if (++casings > Settings.maxCasingsPerController) {
                this.onDisabled();
                return null;
            }
            if (TileEntityController.addNeighbors(this.func_145831_w(), tileEntity, processed, queue)) continue;
            return null;
        }
        this.onDisabled();
        return null;
    }

    private void sendState() {
        MessageCasingEnabledState message = new MessageCasingEnabledState(this, this.isEnabled);
        Network.INSTANCE.getWrapper().sendToDimension((IMessage)message, this.func_145831_w().field_73011_w.getDimension());
    }

    private void dispose() {
        if (this.getController() != null) {
            this.getController().scheduleScan();
        }
        this.casing.onDisposed();
    }

    private void sendCasingLockedState() {
        Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageCasingLockedState(this, this.isLocked()), Network.getTargetPoint(this, 48));
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, this.isLocked() ? 0.5f : 0.6f);
    }

    private void sendReceivingPipeLockedState(Face face, Port port) {
        Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageReceivingPipeLockedState(this, face, port, this.isReceivingPipeLocked(face, port)), Network.getTargetPoint(this, 48));
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, this.isReceivingPipeLocked(face, port) ? 0.5f : 0.6f);
    }

    private static void decompressClosed(byte[] compressed, boolean[][] decompressed) {
        if (compressed.length != 3) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int c = compressed[i >> 1] & 0xFF;
            if ((i & 1) == 1) {
                c >>>= 4;
            }
            boolean[] ports = decompressed[i];
            for (int j = 0; j < 4; ++j) {
                ports[j] = (c & 1 << j) != 0;
            }
        }
    }

    private static byte[] compressClosed(boolean[][] decompressed) {
        byte[] compressed = new byte[3];
        for (int i = 0; i < 6; ++i) {
            boolean[] ports = decompressed[i];
            int c = 0;
            for (int j = 0; j < 4; ++j) {
                if (!ports[j]) continue;
                c |= 1 << j;
            }
            if ((i & 1) == 1) {
                c <<= 4;
            }
            int n = i >> 1;
            compressed[n] = (byte)(compressed[n] | (byte)c);
        }
        return compressed;
    }

    private static final class LockedPipe
    implements Pipe {
        public static final Pipe INSTANCE = new LockedPipe();

        private LockedPipe() {
        }

        @Override
        public void beginWrite(short value) throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isWriting().");
        }

        @Override
        public void cancelWrite() {
        }

        @Override
        public boolean isWriting() {
            return true;
        }

        @Override
        public void beginRead() throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isReading().");
        }

        @Override
        public void cancelRead() {
        }

        @Override
        public boolean isReading() {
            return true;
        }

        @Override
        public boolean canTransfer() {
            return false;
        }

        @Override
        public short read() throws IllegalStateException {
            throw new IllegalStateException("No data to read. Check canTransfer().");
        }
    }
}

