/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.item.ItemFertilizer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class InsolatorManager {
    private static Map<List<ComparableItemStackValidated>, InsolatorRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidated> validationSet = new ObjectOpenHashSet();
    private static Set<ComparableItemStackValidated> lockSet = new ObjectOpenHashSet();
    private static OreValidator oreValidator = new OreValidator();
    public static final int CROP_MULTIPLIER_RICH = 2;
    public static final int CROP_MULTIPLIER_FLUX = 3;
    public static final int FLUID_FACTOR = 4;
    public static final int DEFAULT_ENERGY = 4800;
    public static final int DEFAULT_FLUID = 1200;

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return false;
        }
        ComparableItemStackValidated query = InsolatorManager.convertInput(primaryInput);
        ComparableItemStackValidated querySecondary = InsolatorManager.convertInput(secondaryInput);
        InsolatorRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        return recipe == null && recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static InsolatorRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        ComparableItemStackValidated querySecondary;
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = InsolatorManager.convertInput(primaryInput);
        InsolatorRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary = InsolatorManager.convertInput(secondaryInput)));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return InsolatorManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static InsolatorRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new InsolatorRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(InsolatorManager.convertInput(input));
    }

    public static boolean isItemFertilizer(ItemStack input) {
        return !input.func_190926_b() && lockSet.contains(InsolatorManager.convertInput(input));
    }

    public static void preInit() {
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerBasic);
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerRich);
        InsolatorManager.addFertilizer(ItemFertilizer.fertilizerFlux);
    }

    public static void initialize() {
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O, 2), new ItemStack(Items.field_151014_N), 110);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_185164_cV, 2), new ItemStack(Items.field_185163_cU), 110);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151174_bG, 3), new ItemStack(Items.field_151170_bI), 5);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack(Items.field_151100_aR, 3, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151120_aE, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack((Block)Blocks.field_150434_aF, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150395_bd), new ItemStack(Blocks.field_150395_bd, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150423_aK), new ItemStack(Items.field_151080_bb), 100);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151081_bc), 100);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, 0), new ItemStack((Block)Blocks.field_150327_N, 3, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 0), new ItemStack((Block)Blocks.field_150328_O, 3, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 1), new ItemStack((Block)Blocks.field_150328_O, 3, 1), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 2), new ItemStack((Block)Blocks.field_150328_O, 3, 2), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 3), new ItemStack((Block)Blocks.field_150328_O, 3, 3), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 4), new ItemStack((Block)Blocks.field_150328_O, 3, 4), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 5), new ItemStack((Block)Blocks.field_150328_O, 3, 5), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 6), new ItemStack((Block)Blocks.field_150328_O, 3, 6), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 7), new ItemStack((Block)Blocks.field_150328_O, 3, 7), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 8), new ItemStack((Block)Blocks.field_150328_O, 3, 8), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new ItemStack((Block)Blocks.field_150398_cm, 2, 0), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 1), new ItemStack((Block)Blocks.field_150398_cm, 2, 1), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), new ItemStack((Block)Blocks.field_150398_cm, 2, 4), ItemStack.field_190927_a, 0);
        InsolatorManager.addDefaultRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 5), new ItemStack((Block)Blocks.field_150398_cm, 2, 5), ItemStack.field_190927_a, 0);
        ArrayList<ItemStack> crops = new ArrayList<ItemStack>();
        crops.add(new ItemStack((Block)Blocks.field_150338_P));
        crops.add(new ItemStack((Block)Blocks.field_150337_Q));
        for (ItemStack input : crops) {
            InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)input, (int)2), ItemStack.field_190927_a, 0);
        }
        crops = new ArrayList();
        crops.add(new ItemStack(Items.field_151075_bm));
        for (ItemStack input : crops) {
            InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)input, (int)2), ItemStack.field_190927_a, 0);
        }
        ItemStack input = new ItemStack(Blocks.field_185766_cS);
        ItemStack output = new ItemStack(Items.field_185161_cS);
        InsolatorManager.addDefaultRecipe(input, ItemHelper.cloneStack((ItemStack)output, (int)2), input, 100);
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150364_r, 6, 0), new ItemStack(Blocks.field_150345_g, 1, 0));
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150364_r, 6, 1), new ItemStack(Blocks.field_150345_g, 1, 1));
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 6, 2), new ItemStack(Blocks.field_150345_g, 1, 2));
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 6, 3), new ItemStack(Blocks.field_150345_g, 1, 3));
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(Blocks.field_150363_s, 6, 0), new ItemStack(Blocks.field_150345_g, 1, 4));
        InsolatorManager.addDefaultTreeRecipe(new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(Blocks.field_150363_s, 6, 1), new ItemStack(Blocks.field_150345_g, 1, 5));
        InsolatorManager.loadRecipes();
    }

    public static void loadRecipes() {
        String[] oreNameList;
        for (String name : oreNameList = OreDictionary.getOreNames()) {
            if (!name.startsWith("seed")) continue;
            String oreName = name.substring(4, name.length());
            InsolatorManager.addDefaultOreDictionaryRecipe(oreName);
        }
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        for (Map.Entry<List<ComparableItemStackValidated>, InsolatorRecipe> entry : recipeMap.entrySet()) {
            InsolatorRecipe tempRecipe = entry.getValue();
            ComparableItemStackValidated primary = InsolatorManager.convertInput(tempRecipe.primaryInput);
            ComparableItemStackValidated secondary = InsolatorManager.convertInput(tempRecipe.secondaryInput);
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        ObjectOpenHashSet tempSet2 = new ObjectOpenHashSet();
        for (ComparableItemStackValidated entry : lockSet) {
            ComparableItemStackValidated lock = InsolatorManager.convertInput(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static InsolatorRecipe addRecipe(int energy, int water, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, Type type) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || water <= 0 || InsolatorManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        InsolatorRecipe recipe = new InsolatorRecipe(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy, water, type);
        recipeMap.put(Arrays.asList(InsolatorManager.convertInput(primaryInput), InsolatorManager.convertInput(secondaryInput)), recipe);
        validationSet.add(InsolatorManager.convertInput(primaryInput));
        validationSet.add(InsolatorManager.convertInput(secondaryInput));
        return recipe;
    }

    public static InsolatorRecipe addRecipe(int energy, int water, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return InsolatorManager.addRecipe(energy, water, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, int water, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return InsolatorManager.addRecipe(energy, water, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, int water, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return InsolatorManager.addRecipe(energy, water, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, Type type) {
        return InsolatorManager.addRecipe(energy, energy / 4, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, type);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return InsolatorManager.addRecipe(energy, energy / 4, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return InsolatorManager.addRecipe(energy, energy / 4, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100, Type.STANDARD);
    }

    public static InsolatorRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return InsolatorManager.addRecipe(energy, energy / 4, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0, Type.STANDARD);
    }

    public static InsolatorRecipe removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        InsolatorRecipe recipe = recipeMap.remove(Arrays.asList(InsolatorManager.convertInput(primaryInput), InsolatorManager.convertInput(secondaryInput)));
        return recipe != null ? recipe : recipeMap.remove(Arrays.asList(InsolatorManager.convertInput(secondaryInput), InsolatorManager.convertInput(primaryInput)));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack, oreValidator);
    }

    private static void addFertilizer(ItemStack fertilizer) {
        lockSet.add(InsolatorManager.convertInput(fertilizer));
    }

    public static void addDefaultOreDictionaryRecipe(String oreType) {
        if (oreType.length() <= 0) {
            return;
        }
        String seedName = "seed" + StringHelper.titleCase((String)oreType);
        String cropName = "crop" + StringHelper.titleCase((String)oreType);
        NonNullList registeredSeeds = OreDictionary.getOres((String)seedName, (boolean)false);
        NonNullList registeredCrops = OreDictionary.getOres((String)cropName, (boolean)false);
        if (registeredSeeds.isEmpty() || registeredCrops.isEmpty()) {
            return;
        }
        boolean isTuber = false;
        boolean isBlock = false;
        for (ItemStack seed : registeredSeeds) {
            for (ItemStack crop : registeredCrops) {
                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)seed, (ItemStack)crop)) continue;
                isTuber = true;
            }
        }
        if (ItemHelper.isBlock((ItemStack)((ItemStack)registeredCrops.get(0)))) {
            isBlock = true;
        }
        ItemStack seed = ItemHelper.cloneStack((ItemStack)((ItemStack)registeredSeeds.get(0)), (int)1);
        ItemStack crop = ItemHelper.cloneStack((ItemStack)((ItemStack)registeredCrops.get(0)), (int)(isTuber ? 3 : 1));
        if (isBlock || isTuber) {
            InsolatorManager.addDefaultRecipe(seed, crop, ItemStack.field_190927_a, 0);
        } else {
            InsolatorManager.addDefaultRecipe(seed, crop, seed, 110);
        }
    }

    public static void addDefaultRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        InsolatorManager.addDefaultRecipe(4800, primaryInput, primaryOutput, secondaryOutput, secondaryChance, Type.STANDARD);
    }

    public static void addDefaultRecipe(int energy, ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, Type type) {
        InsolatorManager.addDefaultRecipe(energy, energy / 4, primaryInput, primaryOutput, secondaryOutput, secondaryChance, Math.min(secondaryChance * 2, 125), Math.min(secondaryChance * 3, 150), type);
    }

    public static void addDefaultRecipe(int energy, int water, ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int secondaryChanceRich, int secondaryChanceFlux, Type type) {
        if (!secondaryOutput.func_190926_b()) {
            InsolatorManager.addRecipe(energy, water, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, secondaryOutput, secondaryChance, type);
            InsolatorManager.addRecipe(energy * 3 / 2, water * 3 / 2, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 2)), secondaryOutput, secondaryChanceRich, type);
            InsolatorManager.addRecipe(energy * 2, water * 2, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), secondaryOutput, secondaryChanceFlux, type);
        } else {
            InsolatorManager.addRecipe(energy, water, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, ItemStack.field_190927_a, 0, type);
            InsolatorManager.addRecipe(energy * 3 / 2, water * 3 / 2, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 2)), ItemStack.field_190927_a, 0, type);
            InsolatorManager.addRecipe(energy * 2, water * 2, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), ItemStack.field_190927_a, 0, type);
        }
    }

    public static void addDefaultTreeRecipe(ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        InsolatorManager.addDefaultTreeRecipe(4800, primaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addDefaultTreeRecipe(int energy, ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (!secondaryOutput.func_190926_b()) {
            InsolatorManager.addRecipe(energy * 2, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, secondaryOutput, secondaryChance, Type.TREE);
            InsolatorManager.addRecipe(energy * 2 * 3 / 2, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 2)), secondaryOutput, Math.min(secondaryChance * 2, 125), Type.TREE);
            InsolatorManager.addRecipe(energy * 2 * 2, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), secondaryOutput, Math.min(secondaryChance * 3, 150), Type.TREE);
        } else {
            InsolatorManager.addRecipe(energy * 2, primaryInput, ItemFertilizer.fertilizerBasic, primaryOutput, ItemStack.field_190927_a, 0, Type.TREE);
            InsolatorManager.addRecipe(energy * 2 * 3 / 2, primaryInput, ItemFertilizer.fertilizerRich, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 2)), ItemStack.field_190927_a, 0, Type.TREE);
            InsolatorManager.addRecipe(energy * 2 * 2, primaryInput, ItemFertilizer.fertilizerFlux, ItemHelper.cloneStack((ItemStack)primaryOutput, (int)(primaryOutput.func_190916_E() * 3)), ItemStack.field_190927_a, 0, Type.TREE);
        }
    }

    static {
        oreValidator.addPrefix("seed");
        oreValidator.addPrefix("crop");
    }

    public static enum Type {
        STANDARD,
        TREE;

    }

    public static class InsolatorRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;
        final int water;
        final boolean hasFertilizer;
        final Type type;

        InsolatorRecipe(ItemStack secondaryInput, ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy, int water, Type type) {
            if (InsolatorManager.isItemFertilizer(primaryInput) && !InsolatorManager.isItemFertilizer(secondaryInput)) {
                this.primaryInput = secondaryInput;
                this.secondaryInput = primaryInput;
            } else {
                this.primaryInput = primaryInput;
                this.secondaryInput = secondaryInput;
            }
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
            this.water = water;
            this.type = type;
            this.hasFertilizer = InsolatorManager.isItemFertilizer(secondaryInput) || InsolatorManager.isItemFertilizer(primaryInput);
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getWater() {
            return this.water;
        }

        public Type getType() {
            return this.type;
        }

        public boolean hasFertilizer() {
            return this.hasFertilizer;
        }
    }
}

