/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.blocks;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jotato.quantumflux.Logger;
import jotato.quantumflux.QuantumFluxMod;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockBase
extends Block {
    public BlockBase(String name) {
        this(Material.field_151576_e, name, null, 2.0f);
    }

    public BlockBase(Material material, String name) {
        this(material, name, null, 2.0f);
    }

    public BlockBase(Material material, String name, Class<? extends ItemBlock> itemclass, float hardness) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(QuantumFluxMod.tab);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(hardness);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        if (itemclass != null) {
            ForgeRegistries.ITEMS.register(this.createItemBlock(itemclass).setRegistryName(name));
        } else {
            ForgeRegistries.ITEMS.register(new ItemBlock((Block)this).setRegistryName(name));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        Logger.devLog("    Registering model for %s", this.getRegistryName());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private ItemBlock createItemBlock(Class<? extends ItemBlock> itemBlockClass) {
        try {
            Class[] ctorArgClasses = new Class[]{Block.class};
            Constructor<? extends ItemBlock> itemCtor = itemBlockClass.getConstructor(ctorArgClasses);
            return itemCtor.newInstance(new Object[]{this});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBlockPowered(World worldIn, BlockPos pos) {
        return worldIn.func_175687_A(pos) > 0 || worldIn.func_175640_z(pos);
    }
}

