/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.entangler;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import java.util.UUID;
import javax.annotation.Nullable;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.redflux.IRedfluxProvider;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileRFEntangler
extends TileEntity
implements IEnergyReceiver,
IRedfluxProvider,
IEnergyStorage,
ITickable {
    public UUID owner;
    private long lastIn;
    private long lastOut;
    public long reportedIn;
    public long reportedOut;
    private EnergyStorage storage = new EnergyStorage(ConfigMan.redfluxField_buffer, Integer.MAX_VALUE);

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int taken = this.storage.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            if (!this.field_145850_b.field_72995_K) {
                this.lastIn += (long)taken;
            }
            this.func_70296_d();
        }
        return taken;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.storage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        block2: {
            super.func_145839_a(tag);
            NBTTagCompound energyTag = tag.func_74775_l("Energy");
            this.storage.readFromNBT(energyTag);
            try {
                this.owner = UUID.fromString(tag.func_74779_i("owner"));
            }
            catch (IllegalArgumentException ex) {
                if (this.field_145850_b.field_72995_K) break block2;
                Logger.error("HEY YOU! An RF Entangler at %d, %d, %d has no owner, please replace it.", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        }
        this.registerWithField();
    }

    @Override
    public boolean canSend() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    public int requestEnergy(int energy, boolean simulate) {
        int given = this.storage.extractEnergy(energy, simulate);
        if (!simulate) {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.lastOut += (long)given;
            }
        }
        return given;
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        return energy;
    }

    public void deregisterWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.removeLink(this);
        }
    }

    public void registerWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.registerLink(this);
        }
    }

    @Override
    public String getOwner() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.toString();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.deregisterWithField();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.deregisterWithField();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.registerWithField();
    }

    public void func_73660_a() {
        this.reportedOut = this.lastOut;
        this.reportedIn = this.lastIn;
        this.lastIn = 0L;
        this.lastOut = 0L;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return false;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

