/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter;

import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterBlock;
import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterUpdatePacket;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.utils.Avg;
import com.bymarcin.zettaindustries.utils.MathUtils;
import com.bymarcin.zettaindustries.utils.WorldUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RFMeterTileEntity
extends TileEntity
implements ITickable {
    int transfer = 0;
    int transferLimit = -1;
    long value = 0L;
    long lastValue = 0L;
    Avg avg = new Avg();
    String name = "";
    String password = "";
    boolean inCounterMode = true;
    boolean isOn = true;
    boolean isProtected = false;
    boolean redstone = false;
    int tick = 0;
    public int color = EnumDyeColor.LIME.ordinal();
    ForgeEnergy up = new ForgeEnergy(this, EnumFacing.UP);
    ForgeEnergy down = new ForgeEnergy(this, EnumFacing.DOWN);

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == EnumFacing.UP || facing == EnumFacing.DOWN)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (facing == EnumFacing.UP) {
                return (T)this.up;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.down;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    protected boolean canConnectEnergy(EnumFacing from, boolean receive) {
        return receive ^ this.isInverted() ? from == EnumFacing.UP : from == EnumFacing.DOWN;
    }

    protected int getEnergyStored(EnumFacing from) {
        return 0;
    }

    protected int getMaxEnergyStored(EnumFacing from) {
        return 10000;
    }

    public NBTTagCompound writeNBTData(NBTTagCompound data) {
        data.func_74776_a("color", (float)this.color);
        return data;
    }

    public void readNBTData(NBTTagCompound compound) {
        this.color = compound.func_74762_e("color");
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189515_b(new NBTTagCompound());
        this.writeNBTData(compound);
        return compound;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt != null && pkt.func_148857_g() != null) {
            this.readNBTData(pkt.func_148857_g());
        }
    }

    public void invert() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof RFMeterBlock) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), state.func_177226_a((IProperty)RFMeterBlock.inverted, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)RFMeterBlock.inverted) == false)), 3);
        }
    }

    public boolean isInverted() {
        return (this.func_145832_p() & 1) != 0;
    }

    public int getTransfer() {
        return this.transfer;
    }

    public long getCurrentValue() {
        return this.value;
    }

    public void setPassword(String pass) {
        this.password = MathUtils.encryptPassword(pass);
        this.isProtected = true;
    }

    public void removePassword() {
        this.password = "";
        this.isProtected = false;
    }

    public boolean canEdit(String pass) {
        return !this.isProtected || this.isProtected && pass != null && MathUtils.encryptPassword(pass).equals(this.password);
    }

    public boolean canEnergyFlow() {
        return this.isOn && (this.inCounterMode || 0L < this.value) && !this.redstone;
    }

    private int checkRedstone() {
        EnumFacing front = ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)RFMeterBlock.front)).func_176734_d();
        return this.field_145850_b.func_175651_c(this.func_174877_v().func_177972_a(front), front);
    }

    void updateRedstone() {
        this.redstone = 0 != this.checkRedstone();
    }

    public void onPacket(long value, int transfer, boolean inCounterMode) {
        if (WorldUtils.isServerWorld(this.func_145831_w())) {
            return;
        }
        this.value = value;
        this.transfer = transfer;
        this.inCounterMode = inCounterMode;
    }

    public void func_73660_a() {
        ++this.tick;
        if (WorldUtils.isServerWorld(this.func_145831_w())) {
            if (this.tick % 20 == 0) {
                ZIRegistry.packetHandler.sendToAllAround((IMessage)new RFMeterUpdatePacket(this, this.value, this.transfer, this.inCounterMode), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 32.0));
                this.tick = 0;
            }
            long lastRecive = Math.abs(this.value - this.lastValue);
            this.avg.putValue(lastRecive);
            this.transfer = (int)this.avg.getAvg();
            this.lastValue = this.value;
        } else {
            this.value = this.inCounterMode ? (this.value += (long)this.transfer) : (this.value -= (long)this.transfer);
        }
    }

    protected int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        IEnergyStorage storage;
        if (!this.canEnergyFlow()) {
            return 0;
        }
        int temp = 0;
        if (from == (this.isInverted() ? EnumFacing.DOWN : EnumFacing.UP) && (storage = WorldUtils.getEnergyStorage(this.func_145831_w(), this.func_174877_v(), this.isInverted() ? EnumFacing.UP : EnumFacing.DOWN)) != null) {
            temp = storage.receiveEnergy(this.transferLimit == -1 ? (this.inCounterMode ? maxReceive : Math.min((int)this.value, maxReceive)) : Math.min(this.transferLimit, this.inCounterMode ? maxReceive : Math.min((int)this.value, maxReceive)), simulate);
            if (!simulate) {
                this.value = this.inCounterMode ? (this.value += (long)temp) : (this.value -= (long)temp);
            }
            return temp;
        }
        return 0;
    }

    protected int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt2) {
        NBTTagCompound nbt = super.func_189515_b(nbt2);
        nbt.func_74768_a("transfer", this.transfer);
        nbt.func_74768_a("transferLimit", this.transferLimit);
        nbt.func_74772_a("value", this.value);
        nbt.func_74772_a("lastValue", this.lastValue);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("password", this.password);
        nbt.func_74757_a("inCounterMode", this.inCounterMode);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("isProtected", this.isProtected);
        nbt.func_74768_a("tick", this.tick);
        nbt.func_74768_a("color", this.color);
        nbt.func_74757_a("redstone", this.redstone);
        return nbt;
    }

    public void getTag(NBTTagCompound nbt) {
        nbt.func_74768_a("transferLimit", this.transferLimit);
        nbt.func_74772_a("value", this.value);
        nbt.func_74772_a("lastValue", this.lastValue);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("password", this.password);
        nbt.func_74757_a("inCounterMode", this.inCounterMode);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("isProtected", this.isProtected);
        nbt.func_74768_a("color", this.color);
        nbt.func_74757_a("redstone", this.redstone);
    }

    public void setTag(NBTTagCompound nbt) {
        if (nbt.func_74764_b("transferLimit")) {
            this.transferLimit = nbt.func_74762_e("transferLimit");
        }
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74763_f("value");
        }
        if (nbt.func_74764_b("lastValue")) {
            this.lastValue = nbt.func_74763_f("lastValue");
        }
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("password")) {
            this.password = nbt.func_74779_i("password");
        }
        if (nbt.func_74764_b("inCounterMode")) {
            this.inCounterMode = nbt.func_74767_n("inCounterMode");
        }
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("isProtected")) {
            this.isProtected = nbt.func_74767_n("isProtected");
        }
        if (nbt.func_74764_b("color")) {
            this.color = nbt.func_74762_e("color");
        }
        if (nbt.func_74764_b("redstone")) {
            this.redstone = nbt.func_74767_n("redstone");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("transfer")) {
            this.transfer = nbt.func_74762_e("transfer");
        }
        if (nbt.func_74764_b("transferLimit")) {
            this.transferLimit = nbt.func_74762_e("transferLimit");
        }
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74763_f("value");
        }
        if (nbt.func_74764_b("lastValue")) {
            this.lastValue = nbt.func_74763_f("lastValue");
        }
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("password")) {
            this.password = nbt.func_74779_i("password");
        }
        if (nbt.func_74764_b("inCounterMode")) {
            this.inCounterMode = nbt.func_74767_n("inCounterMode");
        }
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("isProtected")) {
            this.isProtected = nbt.func_74767_n("isProtected");
        }
        if (nbt.func_74764_b("tick")) {
            this.tick = nbt.func_74762_e("tick");
        }
        if (nbt.func_74764_b("color")) {
            this.color = nbt.func_74762_e("color");
        }
        if (nbt.func_74764_b("redstone")) {
            this.redstone = nbt.func_74767_n("redstone");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return newSate.func_177230_c() != oldState.func_177230_c();
    }

    class ForgeEnergy
    implements IEnergyStorage {
        RFMeterTileEntity tileEntity;
        EnumFacing face;

        public ForgeEnergy(RFMeterTileEntity tileEntity, EnumFacing face) {
            this.tileEntity = tileEntity;
            this.face = face;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.tileEntity.receiveEnergy(this.face, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.tileEntity.extractEnergy(this.face, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.tileEntity.getEnergyStored(this.face);
        }

        public int getMaxEnergyStored() {
            return this.tileEntity.getMaxEnergyStored(this.face);
        }

        public boolean canExtract() {
            return this.tileEntity.canConnectEnergy(this.face, false);
        }

        public boolean canReceive() {
            return this.tileEntity.canConnectEnergy(this.face, true);
        }
    }
}

