/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.blocks.blockitems.BlockItemBookcase;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBookcase
extends BiblioWoodBlock {
    public static final String name = "Bookcase";
    public static final BlockBookcase instance = new BlockBookcase("Bookcase");

    public BlockBookcase(String blockName) {
        super(blockName, true);
        this.func_149675_a(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)world.func_175625_s(pos);
            ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
            if (playerhand != ItemStack.field_190927_a && playerhand.func_77973_b() instanceof BlockItemBookcase) {
                return false;
            }
            if (biblioTile instanceof TileEntityBookcase) {
                TileEntityBookcase tileBookCase = (TileEntityBookcase)biblioTile;
                int yCheck = (int)(hitY * 2.0f);
                EnumFacing angle = tileBookCase.getAngle();
                if (yCheck == 1) {
                    int booktest = BlockBookcase.isWhatBook(angle, hitX, hitZ);
                    if (player.func_70093_af()) {
                        if (booktest >= 0 && booktest < 16) {
                            this.dropStackInSlot(world, pos, booktest, this.getDropPositionOffset(pos, player));
                            tileBookCase.setBook(booktest, ItemStack.field_190927_a);
                        }
                        return true;
                    }
                    if (playerhand != ItemStack.field_190927_a) {
                        if (!Config.isBlock(playerhand) && Config.testBookValidity(playerhand)) {
                            boolean addedBook;
                            if (booktest >= 0 && booktest < 16 && (addedBook = tileBookCase.setBook(booktest, playerhand))) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                                return true;
                            }
                        } else {
                            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                            return true;
                        }
                    }
                } else if (yCheck == 0) {
                    int booktest = BlockBookcase.isWhatBook(angle, hitX, hitZ) + 8;
                    if (player.func_70093_af()) {
                        if (booktest >= 0 && booktest < 16) {
                            this.dropStackInSlot(world, pos, booktest, this.getDropPositionOffset(pos, player));
                            tileBookCase.setBook(booktest, ItemStack.field_190927_a);
                        }
                        return true;
                    }
                    if (playerhand != ItemStack.field_190927_a) {
                        if (!Config.isBlock(playerhand) && Config.testBookValidity(playerhand)) {
                            boolean addedBook;
                            if (booktest >= 0 && booktest < 16 && (addedBook = tileBookCase.setBook(booktest, playerhand))) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                                return true;
                            }
                        } else {
                            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                            return true;
                        }
                    }
                }
                player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBookcase();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList modelParts = new ArrayList();
        if (tile instanceof TileEntityBookcase) {
            TileEntityBookcase bookcase = (TileEntityBookcase)tile;
            int[] books = bookcase.getCheckedBooks();
            modelParts.add("bookcase");
            for (int i = 0; i < books.length; ++i) {
                if (books[i] != 1) continue;
                modelParts.add("book" + (i + 1));
            }
        } else {
            modelParts = Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
        }
        return modelParts;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityBookcase) {
            TileEntityBookcase bookcase = (TileEntityBookcase)tile;
            return 0.125f * (float)bookcase.getFilledSlots();
        }
        return 0.0f;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess blocka, BlockPos pos, EnumFacing side) {
        TileEntity tile = blocka.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityBookcase) {
            TileEntityBookcase bookcase = (TileEntityBookcase)blocka.func_175625_s(pos);
            EnumFacing angle = bookcase.getAngle();
            if (bookcase.getredstone()) {
                switch (angle) {
                    case SOUTH: {
                        if (side == EnumFacing.EAST) {
                            return 0;
                        }
                        return bookcase.getRedstoneBookSlot();
                    }
                    case WEST: {
                        if (side == EnumFacing.SOUTH) {
                            return 0;
                        }
                        return bookcase.getRedstoneBookSlot();
                    }
                    case NORTH: {
                        if (side == EnumFacing.WEST) {
                            return 0;
                        }
                        return bookcase.getRedstoneBookSlot();
                    }
                    case EAST: {
                        if (side == EnumFacing.NORTH) {
                            return 0;
                        }
                        return bookcase.getRedstoneBookSlot();
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, worldIn, pos, side);
    }

    public static boolean isTopShelf(float hitY) {
        return (double)hitY > 0.5;
    }

    public static int isWhatBook(EnumFacing angle, float hitX, float hitZ) {
        int xt = (int)(hitX * 8.0f);
        int zt = (int)(hitZ * 8.0f);
        switch (angle) {
            case SOUTH: {
                return zt;
            }
            case WEST: {
                switch (xt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case NORTH: {
                switch (zt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case EAST: {
                return xt;
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rando) {
        TileEntityBookcase bookcase;
        super.func_180655_c(state, world, pos, rando);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityBookcase && (bookcase = (TileEntityBookcase)tile) != null && bookcase.getFilledSlots() > 0) {
            for (int x = pos.func_177958_n() - 2; x <= pos.func_177958_n() + 2; ++x) {
                block1: for (int z = pos.func_177952_p() - 2; z <= pos.func_177952_p() + 2; ++z) {
                    if (x > pos.func_177958_n() - 2 && x < pos.func_177958_n() + 2 && z == pos.func_177952_p() - 1) {
                        z = pos.func_177952_p() + 2;
                    }
                    if (rando.nextInt(8) != 0) continue;
                    for (int y = pos.func_177956_o() - 1; y <= pos.func_177956_o() + 1; ++y) {
                        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150381_bn) continue;
                        if (!world.func_175623_d(new BlockPos((x - pos.func_177958_n()) / 2 + pos.func_177958_n(), y, (z - pos.func_177952_p()) / 2 + pos.func_177952_p()))) continue block1;
                        double px = (double)x + 0.5;
                        double py = (double)y + 2.0;
                        double pz = (double)z + 0.5;
                        double velx = (double)((float)(pos.func_177958_n() - x) + rando.nextFloat()) - 0.5;
                        double vely = (float)(pos.func_177956_o() - y) - rando.nextFloat() - 1.0f;
                        double velz = (double)((float)(pos.func_177952_p() - z) + rando.nextFloat()) - 0.5;
                        world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, px, py, pz, velx, vely, velz, new int[0]);
                    }
                }
            }
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }
}

