/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import net.minecraft.block.Block;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;

public class MaterialIntegration {
    public Material material;
    public Fluid fluid;
    public String oreSuffix;
    public String[] oreRequirement;
    public String representativeItem;
    private boolean integrated;
    private boolean preInit;
    private boolean toolforge = false;
    private boolean addedFluidBlock;

    public MaterialIntegration(Material material) {
        this(material, null);
    }

    public MaterialIntegration(Material material, Fluid fluid) {
        this(null, material, fluid, null);
    }

    public MaterialIntegration(Material material, Fluid fluid, String oreSuffix) {
        this("ingot" + oreSuffix, material, fluid, oreSuffix);
    }

    public MaterialIntegration(String oreRequirement, Material material, Fluid fluid, String oreSuffix) {
        this(material, fluid, oreSuffix, oreRequirement);
    }

    public MaterialIntegration(Material material, Fluid fluid, String oreSuffix, String ... oreRequirement) {
        this.material = material;
        this.fluid = fluid;
        this.oreSuffix = oreSuffix;
        this.representativeItem = "ingot" + oreSuffix;
        this.oreRequirement = oreRequirement[0] == null ? new String[]{} : oreRequirement;
        this.integrated = false;
        this.preInit = false;
        this.addedFluidBlock = false;
    }

    public MaterialIntegration toolforge() {
        this.toolforge = true;
        return this;
    }

    public MaterialIntegration setRepresentativeItem(String representativeItem) {
        this.representativeItem = representativeItem;
        return this;
    }

    public boolean isIntegrated() {
        return this.integrated;
    }

    public void preInit() {
        if (this.preInit) {
            return;
        }
        this.preInit = true;
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            this.fluid = null;
        }
        if (this.fluid != null) {
            Fluid registeredFluid = FluidRegistry.getFluid((String)this.fluid.getName());
            if (!FluidRegistry.getBucketFluids().contains(registeredFluid)) {
                FluidRegistry.addBucketForFluid((Fluid)registeredFluid);
            }
        }
        if (this.material != null) {
            TinkerRegistry.addMaterial(this.material);
            if (this.fluid != null) {
                this.material.setFluid(this.fluid);
                this.material.setCastable(true);
            } else {
                this.material.setCraftable(true);
            }
        }
    }

    public void integrate() {
        if (this.integrated) {
            return;
        }
        if (this.oreRequirement != null && this.oreRequirement.length > 0 && !Config.forceRegisterAll) {
            for (String ore : this.oreRequirement) {
                if (!OreDictionary.getOres((String)ore, (boolean)false).isEmpty()) continue;
                return;
            }
        }
        this.integrated = true;
        if (this.fluid != null && this.oreSuffix != null) {
            TinkerSmeltery.registerOredictMeltingCasting(this.fluid, this.oreSuffix);
        }
        if (this.material != null) {
            this.material.setVisible();
            TinkerSmeltery.registerToolpartMeltingCasting(this.material);
            this.registerRepresentativeItem();
        }
    }

    private void registerRepresentativeItem() {
        if (this.material.getRepresentativeItem().func_190926_b() && this.representativeItem != null && !this.representativeItem.isEmpty()) {
            this.material.setRepresentativeItem(this.representativeItem);
        }
    }

    public void registerToolForgeRecipe(IForgeRegistry<IRecipe> registry) {
        if (this.toolforge && this.oreSuffix != null && !this.oreSuffix.isEmpty()) {
            TinkerTools.registerToolForgeBlock(registry, "block" + this.oreSuffix);
        }
    }

    public void registerFluidBlock(IForgeRegistry<Block> registry) {
        if (this.fluid != null && this.fluid.getBlock() == null) {
            this.addedFluidBlock = true;
            TinkerFluids.registerMoltenBlock(registry, this.fluid);
        }
    }

    public void registerFluidModel() {
        if (this.addedFluidBlock) {
            TinkerFluids.proxy.registerFluidModels(this.fluid);
        }
    }
}

