/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class TankItemModel
extends BakedModelWrapper<IBakedModel> {
    private static final Cache<TankCacheKey, IBakedModel> CACHE = CacheBuilder.newBuilder().maximumSize(30L).build();
    private ItemOverrideList overrides;

    public TankItemModel(IBakedModel originalModel) {
        super(originalModel);
        this.overrides = new ItemTextureOverride(originalModel.func_188617_f());
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private static IBakedModel getTexturedModel(IBakedModel original, ResourceLocation location, Fluid fluid) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            IModel retextured = model.retexture(ImmutableMap.of((Object)"fluid", (Object)fluid.getStill().toString()));
            return retextured.bake(retextured.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    private static class TankCacheKey {
        private ResourceLocation location;
        private Fluid fluid;

        private TankCacheKey(@Nonnull ResourceLocation location, @Nonnull Fluid fluid) {
            this.location = location;
            this.fluid = fluid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TankCacheKey that = (TankCacheKey)o;
            return that.fluid == this.fluid && that.location.equals((Object)this.location);
        }

        public int hashCode() {
            return 31 * this.location.hashCode() + this.fluid.hashCode();
        }
    }

    private static class ItemTextureOverride
    extends ItemOverrideList {
        private ItemOverrideList parent;

        private ItemTextureOverride(ItemOverrideList list) {
            super(Collections.emptyList());
            this.parent = list;
        }

        @Deprecated
        public ResourceLocation func_188021_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return this.parent.func_188021_a(stack, worldIn, entityIn);
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel original, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack.func_190926_b() || !stack.func_77973_b().func_185040_i() || !stack.func_77942_o()) {
                return original;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
            if (fluid == null || fluid.amount == 0 || fluid.getFluid() == null) {
                return original;
            }
            ResourceLocation location = this.parent.func_188021_a(stack, world, entity);
            if (location == null) {
                return original;
            }
            try {
                return (IBakedModel)CACHE.get((Object)new TankCacheKey(location, fluid.getFluid()), () -> TankItemModel.getTexturedModel(original, location, fluid.getFluid()));
            }
            catch (ExecutionException e) {
                TinkerSmeltery.log.error((Object)e);
                return original;
            }
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return this.parent.getOverrides();
        }
    }
}

