/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.IContainerCraftingCustom;
import slimeknights.mantle.inventory.SlotCraftingCustom;
import slimeknights.mantle.inventory.SlotOut;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.ListUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.common.client.GuiPartBuilder;
import slimeknights.tconstruct.tools.common.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.inventory.SlotStencil;
import slimeknights.tconstruct.tools.common.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.common.tileentity.TilePatternChest;

public class ContainerPartBuilder
extends ContainerTinkerStation<TilePartBuilder>
implements IContainerCraftingCustom {
    public IInventory craftResult;
    private final Slot patternSlot;
    private final Slot secondarySlot;
    private final Slot input1;
    private final Slot input2;
    private final boolean partCrafter;
    private final EntityPlayer player;
    public final IInventory patternChest;

    public ContainerPartBuilder(InventoryPlayer playerInventory, TilePartBuilder tile) {
        super(tile);
        InventoryCraftingPersistent craftMatrix = new InventoryCraftingPersistent((Container)this, (IInventory)tile, 1, 3);
        this.craftResult = new InventoryCraftResult();
        this.player = playerInventory.field_70458_d;
        this.func_75146_a((Slot)new SlotCraftingCustom((IContainerCraftingCustom)this, playerInventory.field_70458_d, (InventoryCrafting)craftMatrix, this.craftResult, 0, 106, 35));
        this.secondarySlot = new SlotOut((IInventory)tile, 3, 132, 35);
        this.func_75146_a(this.secondarySlot);
        this.patternSlot = new SlotStencil((IInventory)craftMatrix, 2, 26, 35, false);
        this.func_75146_a(this.patternSlot);
        this.input1 = new Slot((IInventory)craftMatrix, 0, 48, 26);
        this.func_75146_a(this.input1);
        this.input2 = new Slot((IInventory)craftMatrix, 1, 48, 44);
        this.func_75146_a(this.input2);
        TilePatternChest chest = (TilePatternChest)this.detectTE(TilePatternChest.class);
        if (chest != null) {
            boolean hasCraftingStation = false;
            boolean hasStencilTable = false;
            for (Pair pair : this.tinkerStationBlocks) {
                BlockToolTable.TableTypes type;
                if (!((IBlockState)pair.getRight()).func_177228_b().containsKey(BlockToolTable.TABLES) || (type = (BlockToolTable.TableTypes)((Object)((IBlockState)pair.getRight()).func_177229_b(BlockToolTable.TABLES))) == null) continue;
                if (type == BlockToolTable.TableTypes.CraftingStation) {
                    hasCraftingStation = true;
                    continue;
                }
                if (type != BlockToolTable.TableTypes.StencilTable) continue;
                hasStencilTable = true;
            }
            this.partCrafter = hasStencilTable && hasCraftingStation;
            ContainerPatternChest.DynamicChestInventory sideInventory = new ContainerPatternChest.DynamicChestInventory(chest, (IInventory)chest, -6, 8, 6);
            this.addSubContainer((Container)sideInventory, true);
            this.patternChest = chest;
        } else {
            this.partCrafter = false;
            this.patternChest = null;
        }
        this.addPlayerInventory(playerInventory, 8, 84);
        this.func_75130_a((IInventory)playerInventory);
    }

    public boolean isPartCrafter() {
        return this.partCrafter;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.updateResult();
    }

    public void updateResult() {
        if (!this.patternSlot.func_75216_d() || !this.input1.func_75216_d() && !this.input2.func_75216_d() && !this.secondarySlot.func_75216_d()) {
            this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
            this.updateGUI();
        } else {
            NonNullList<ItemStack> toolPart;
            TinkerGuiException throwable = null;
            try {
                toolPart = ToolBuilder.tryBuildToolPart(this.patternSlot.func_75211_c(), ListUtil.getListFrom(this.input1.func_75211_c(), this.input2.func_75211_c()), false);
                if (toolPart != null && !((ItemStack)toolPart.get(0)).func_190926_b()) {
                    TinkerCraftingEvent.ToolPartCraftingEvent.fireEvent((ItemStack)toolPart.get(0), this.player);
                }
            }
            catch (TinkerGuiException e) {
                toolPart = null;
                throwable = e;
            }
            ItemStack secondary = this.secondarySlot.func_75211_c();
            if (toolPart != null && (secondary.func_190926_b() || ((ItemStack)toolPart.get(1)).func_190926_b() || ItemStack.func_179545_c((ItemStack)secondary, (ItemStack)((ItemStack)toolPart.get(1))) && ItemStack.func_77970_a((ItemStack)secondary, (ItemStack)((ItemStack)toolPart.get(1))))) {
                this.craftResult.func_70299_a(0, (ItemStack)toolPart.get(0));
            } else {
                this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
            }
            if (throwable != null) {
                this.error(throwable.getMessage());
            } else {
                this.updateGUI();
            }
        }
    }

    public void setPattern(ItemStack wanted) {
        if (this.patternChest == null) {
            return;
        }
        for (int i = 0; i < this.patternChest.func_70302_i_(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)wanted, (ItemStack)this.patternChest.func_70301_a(i))) continue;
            ItemStack slotStack = this.patternSlot.func_75211_c();
            this.patternSlot.func_75215_d(this.patternChest.func_70301_a(i));
            this.patternChest.func_70299_a(i, slotStack);
            break;
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack output, IInventory craftMatrix) {
        NonNullList<ItemStack> toolPart = NonNullList.func_191196_a();
        try {
            toolPart = ToolBuilder.tryBuildToolPart(this.patternSlot.func_75211_c(), ListUtil.getListFrom(this.input1.func_75211_c(), this.input2.func_75211_c()), true);
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        if (toolPart == null) {
            return;
        }
        ItemStack secondOutput = (ItemStack)toolPart.get(1);
        ItemStack secondary = this.secondarySlot.func_75211_c();
        if (secondary.func_190926_b()) {
            this.func_75141_a(this.secondarySlot.field_75222_d, secondOutput);
        } else if (!secondOutput.func_190926_b() && ItemStack.func_179545_c((ItemStack)secondary, (ItemStack)secondOutput) && ItemStack.func_77970_a((ItemStack)secondary, (ItemStack)secondOutput)) {
            secondary.func_190917_f(secondOutput.func_190916_E());
        }
        this.updateResult();
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    public String getInventoryDisplayName() {
        if (this.partCrafter) {
            return Util.translate("gui.partcrafter.name", new Object[0]);
        }
        return super.getInventoryDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75141_a(int p_75141_1_, @Nonnull ItemStack p_75141_2_) {
        super.func_75141_a(p_75141_1_, p_75141_2_);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiPartBuilder) {
            ((GuiPartBuilder)mc.field_71462_r).updateButtons();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_184996_a(int slotId, int dragType, ClickType type, EntityPlayer player) {
        ItemStack ret = super.func_184996_a(slotId, dragType, type, player);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiPartBuilder) {
            ((GuiPartBuilder)mc.field_71462_r).updateButtons();
        }
        return ret;
    }
}

