/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPStaticConfig;
import com.therandomlabs.randompatches.util.RPUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Config(modid="randompatches", name="randompatches", category="")
public final class RPConfig {
    @Config.LangKey(value="randompatches.config.boats")
    @Config.Comment(value={"Options related to boats."})
    public static final Boats boats = new Boats();
    @Config.LangKey(value="randompatches.config.client")
    @Config.Comment(value={"Options related to client-sided features."})
    public static final Client client = new Client();
    @Config.LangKey(value="randompatches.config.misc")
    @Config.Comment(value={"Options that don't fit into any other categories."})
    public static final Misc misc = new Misc();
    @Config.LangKey(value="randompatches.config.speedLimits")
    @Config.Comment(value={"Options related to the movement speed limits."})
    public static final SpeedLimits speedLimits = new SpeedLimits();
    @Config.LangKey(value="randompatches.config.timeouts")
    @Config.Comment(value={"Options related to the disconnect timeouts."})
    public static final Timeouts timeouts = new Timeouts();
    private static final Field ASM_DATA = RPUtils.findField(ConfigManager.class, "asm_data");
    private static final Method GET_CONFIGURATION = RPUtils.findMethod(ConfigManager.class, "getConfiguration", "getConfiguration", String.class, String.class);
    private static final Method SYNC = RPUtils.findMethod(ConfigManager.class, "sync", "sync", Configuration.class, Class.class, String.class, String.class, Boolean.TYPE, Object.class);
    private static final Map<Class<?>, Map<Object, Field[]>> propertyCacheMap = new HashMap();
    private static final Map<String, Map<Property, String>> commentMap = new HashMap<String, Map<Property, String>>();

    public static void reload() {
        RPConfig.reload("randompatches", RPConfig.class, RPStaticConfig.class, RPStaticConfig::onReload);
    }

    public static void reload(String modid, Class<?> configClass, Class<?> staticConfigClass, Runnable onReload) {
        if (!ConfigManager.hasConfigForMod((String)modid)) {
            try {
                RPConfig.injectASMData(modid, configClass);
            }
            catch (Exception ex) {
                RandomPatches.LOGGER.error("Failed to load config", (Throwable)ex);
                return;
            }
        }
        try {
            ConfigCategory category;
            Configuration config = (Configuration)GET_CONFIGURATION.invoke(null, modid, modid);
            if (config == null) {
                ConfigManager.sync((String)modid, (Config.Type)Config.Type.INSTANCE);
                config = (Configuration)GET_CONFIGURATION.invoke(null, modid, modid);
            } else {
                SYNC.invoke(null, config, configClass, modid, "", false, null);
            }
            Map<Object, Field[]> properties = RPConfig.getProperties(configClass);
            RPConfig.copyValuesToStatic(properties, staticConfigClass);
            onReload.run();
            RPConfig.copyValuesFromStatic(properties, staticConfigClass);
            Map comments = commentMap.computeIfAbsent(modid, property -> new HashMap());
            for (String name : config.getCategoryNames()) {
                category = config.getCategory(name);
                category.getValues().forEach((key, property) -> {
                    String comment = property.getComment();
                    if (comment == null || comment.isEmpty()) {
                        category.remove(key);
                        return;
                    }
                    String newComment = (String)comments.get(property);
                    if (newComment == null) {
                        newComment = comment + "\nDefault: " + property.getDefault();
                        comments.put(property, newComment);
                    }
                    property.setComment(newComment);
                });
                if (!category.getValues().isEmpty() && category.getComment() != null) continue;
                config.removeCategory(category);
            }
            config.save();
            SYNC.invoke(null, config, configClass, modid, "", false, null);
            for (String name : config.getCategoryNames()) {
                category = config.getCategory(name);
                category.getValues().forEach((key, property) -> {
                    String[] comment = property.getComment().split("\n");
                    StringBuilder prunedComment = new StringBuilder();
                    for (String line : comment) {
                        if (line.startsWith("Default:") || line.startsWith("Min:")) break;
                        prunedComment.append(line).append("\n");
                    }
                    String commentString = prunedComment.toString();
                    property.setComment(commentString.substring(0, commentString.length() - 1));
                });
            }
        }
        catch (Exception ex) {
            RandomPatches.LOGGER.error("Error while modifying config", (Throwable)ex);
        }
    }

    public static void reloadFromDisk() {
        RPConfig.prepareReloadFromDisk("randompatches");
        RPConfig.reload();
    }

    public static void prepareReloadFromDisk(String modid) {
        try {
            Configuration config = (Configuration)GET_CONFIGURATION.invoke(null, modid, modid);
            Configuration tempConfig = new Configuration(config.getConfigFile());
            tempConfig.load();
            for (String name : tempConfig.getCategoryNames()) {
                Map properties = tempConfig.getCategory(name).getValues();
                for (Map.Entry entry : properties.entrySet()) {
                    config.getCategory(name).get((String)entry.getKey()).set(((Property)entry.getValue()).getString());
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent(modid, null, true, false));
        }
        catch (Exception ex) {
            RandomPatches.LOGGER.error("Error while modifying config", (Throwable)ex);
        }
    }

    private static void injectASMData(String modid, Class<?> configClass) throws IllegalAccessException {
        Map asmData = (Map)ASM_DATA.get(null);
        Multimap data = asmData.computeIfAbsent(modid, id -> ArrayListMultimap.create());
        HashMap<String, String> annotationInfo = new HashMap<String, String>();
        annotationInfo.put("modid", modid);
        annotationInfo.put("name", modid);
        annotationInfo.put("category", "");
        data.put((Object)Config.Type.INSTANCE, (Object)new ASMDataTable.ASMData(null, null, configClass.getName(), null, annotationInfo));
    }

    private static void copyValuesToStatic(Map<Object, Field[]> properties, Class<?> staticConfigClass) throws IllegalAccessException, NoSuchFieldException {
        for (Map.Entry<Object, Field[]> entry : properties.entrySet()) {
            Field[] propertyArray;
            Object object = entry.getKey();
            for (Field property : propertyArray = entry.getValue()) {
                Object value = property.get(object);
                staticConfigClass.getDeclaredField(property.getName()).set(null, value);
            }
        }
    }

    private static void copyValuesFromStatic(Map<Object, Field[]> properties, Class<?> staticConfigClass) throws IllegalAccessException, NoSuchFieldException {
        for (Map.Entry<Object, Field[]> entry : properties.entrySet()) {
            Field[] propertyArray;
            Object object = entry.getKey();
            for (Field property : propertyArray = entry.getValue()) {
                Object value = staticConfigClass.getDeclaredField(property.getName()).get(null);
                property.set(object, value);
            }
        }
    }

    private static Map<Object, Field[]> getProperties(Class<?> configClass) {
        Map properties = propertyCacheMap.computeIfAbsent(configClass, clazz -> new HashMap());
        if (!properties.isEmpty()) {
            return properties;
        }
        try {
            HashMap<Object, Field> nestedCategories = new HashMap<Object, Field>();
            for (Field field : configClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers)) continue;
                Object object = field.get(null);
                Field[] propertyArray = object.getClass().getDeclaredFields();
                ArrayList<Field> propertyList = new ArrayList<Field>();
                for (Field property : propertyArray) {
                    if (NestedCategory.class.isAssignableFrom(property.getType())) {
                        nestedCategories.put(object, property);
                        continue;
                    }
                    propertyList.add(property);
                }
                properties.put(object, propertyList.toArray(new Field[0]));
            }
            for (Map.Entry entry : nestedCategories.entrySet()) {
                Object object = ((Field)entry.getValue()).get(entry.getKey());
                properties.put(object, object.getClass().getDeclaredFields());
            }
        }
        catch (Exception ex) {
            RandomPatches.LOGGER.error("Error while getting config properties", (Throwable)ex);
        }
        propertyCacheMap.put(configClass, properties);
        return properties;
    }

    public static interface NestedCategory {
    }

    public static final class Window
    implements NestedCategory {
        @Config.LangKey(value="randompatches.config.window.icon16")
        @Config.Comment(value={"The path to the 16x16 Minecraft window icon.\nLeave this and the 32x32 icon blank to use the default icon."})
        public String icon16 = RPStaticConfig.Defaults.ICON_16;
        @Config.LangKey(value="randompatches.config.window.icon32")
        @Config.Comment(value={"The path to the 32x32 Minecraft window icon.\nLeave this and the 16x16 icon blank to use the default icon."})
        public String icon32 = RPStaticConfig.Defaults.ICON_32;
        @Config.LangKey(value="randompatches.config.window.title")
        @Config.Comment(value={"The Minecraft window title."})
        public String title = RPStaticConfig.Defaults.TITLE;
    }

    public static final class Timeouts {
        @Config.RangeInt(min=1)
        @Config.LangKey(value="randompatches.config.timeouts.keepAlivePacketInterval")
        @Config.Comment(value={"The interval at which the server sends the KeepAlive packet."})
        public int keepAlivePacketInterval = 15;
        @Config.RangeInt(min=1)
        @Config.LangKey(value="randompatches.config.timeouts.loginTimeout")
        @Config.Comment(value={"The login timeout."})
        public int loginTimeout = 900;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.timeouts.patchLoginTimeout")
        @Config.Comment(value={"Whether to apply the login timeout."})
        public boolean patchLoginTimeout = true;
        @Config.RangeInt(min=1)
        @Config.LangKey(value="randompatches.config.timeouts.readTimeout")
        @Config.Comment(value={"The read timeout.\nThis is the time it takes for a player to be disconnected after not responding to a KeepAlive packet.\nThis value is automatically rounded up to a product of keepAlivePacketInterval.\nThis only works on 1.12 and above."})
        public int readTimeout = 90;
    }

    public static final class SpeedLimits {
        @Config.RangeDouble(min=1.0)
        @Config.LangKey(value="randompatches.config.speedLimits.maxPlayerSpeed")
        @Config.Comment(value={"The maximum player speed.\nThe vanilla default is 100.0."})
        public float maxPlayerSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.LangKey(value="randompatches.config.speedLimits.maxPlayerElytraSpeed")
        @Config.Comment(value={"The maximum player elytra speed.\nThe vanilla default is 300.0."})
        public float maxPlayerElytraSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.LangKey(value="randompatches.config.speedLimits.maxPlayerVehicleSpeed")
        @Config.Comment(value={"The maximum player vehicle speed.\nThe vanilla default is 100.0."})
        public double maxPlayerVehicleSpeed = 1000000.0;
    }

    public static final class Misc {
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.endPortalTweaks")
        @Config.Comment(value={"Fixes the End portal and End gateway break particle textures and improves End portal rendering.\nThis only works on Minecraft 1.11 and above."})
        public boolean endPortalTweaks = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.mc2025Fix")
        @Config.Comment(value={"Fixes MC-2025.\nThis only works on 1.10 and above.\nMore information can be found here: https://www.reddit.com/r/Mojira/comments/8pgd4q/final_and_proper_fix_to_mc2025_simple_reliable/"})
        public boolean mc2025Fix = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.minecartAIFix")
        @Config.Comment(value={"Fixes MC-64836, which causes non-player entities to be allowed to control minecarts using their AI."})
        public boolean minecartAIFix = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.patchNetHandlerPlayServer")
        @Config.Comment(value={"Set this to false to disable the NetHandlerPlayServer patches (the speed limits and disconnect timeouts).\nOn 1.8, 1.8.8 and 1.8.9, these patches are always disabled."})
        public boolean patchNetHandlerPlayServer = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.portalBucketReplacementFix")
        @Config.Comment(value={"Fixes MC-11944, which allows players to replace End portals, End gateways and Nether portals using buckets."})
        public boolean portalBucketReplacementFix = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.portalBucketReplacementFixForNetherPortals")
        @Config.Comment(value={"Enables the portal bucket replacement fix for Nether portals."})
        public boolean portalBucketReplacementFixForNetherPortals = false;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.recipeBookNBTFix")
        @Config.Comment(value={"Fixes MC-129057, which prevents ingredients with NBT data from being transferred to the crafting grid when a recipe is clicked in the recipe book."})
        public boolean recipeBookNBTFix = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.replaceTeleporter")
        @Config.Comment(value={"Whether to allow other mods (namely RandomPortals) to replace the default Teleporter on 1.12."})
        public boolean replaceTeleporter = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randompatches.config.misc.rpreload")
        @Config.Comment(value={"Enables the /rpreload command."})
        public boolean rpreload = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.misc.skullStackingFix")
        @Config.Comment(value={"Fixes player skull stacking."})
        public boolean skullStackingFix = true;
        @Config.LangKey(value="randompatches.config.misc.skullStackingRequiresSameTextures")
        @Config.Comment(value={"Whether skull stacking requires the same textures or just the same player profile."})
        public boolean skullStackingRequiresSameTextures = true;
    }

    public static final class Client {
        @Config.LangKey(value="randompatches.config.window")
        @Config.Comment(value={"Options related to the Minecraft window."})
        public final Window window = new Window();
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.client.fastLanguageSwitch")
        @Config.Comment(value={"Speeds up language switching."})
        public boolean fastLanguageSwitch = true;
        @Config.LangKey(value="randompatches.config.client.forceTitleScreenOnDisconnect")
        @Config.Comment(value={"Forces Minecraft to show the title screen after disconnecting rather than the Multiplayer or Realms menu."})
        public boolean forceTitleScreenOnDisconnect = RPStaticConfig.Defaults.FORCE_TITLE_SCREEN_ON_DISCONNECT;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.client.narratorKeybind")
        @Config.Comment(value={"Whether to add the Toggle Narrator keybindto the controls.\nThis only works on 1.12 as the narrator does not exist in previous versions."})
        public boolean narratorKeybind = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.client.patchMinecraftClass")
        @Config.Comment(value={"Set this to false to disable the Minecraft class patches (the Toggle Narrator keybind and custom window title/icon)."})
        public boolean patchMinecraftClass = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.client.patchTitleScreenOnDisconnect")
        @Config.Comment(value={"Set this to false to force disable the \"force title screen on disconnect\" apply."})
        public boolean patchTitleScreenOnDisconnect = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.client.removePotionGlint")
        @Config.Comment(value={"Whether to remove the glowing effect from potions."})
        public boolean removePotionGlint = RPStaticConfig.Defaults.REMOVE_POTION_GLINT;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randompatches.config.client.rpreloadclient")
        @Config.Comment(value={"Enables the /rpreloadclient command."})
        public boolean rpreloadclient = true;
    }

    public static final class Boats {
        @Config.RequiresMcRestart
        @Config.LangKey(value="randompatches.config.boats.patchEntityBoat")
        @Config.Comment(value={"Whether to patch EntityBoat.\nThis only works on 1.9 and above."})
        public boolean patchEntityBoat = true;
        @Config.LangKey(value="randompatches.config.boats.preventUnderwaterBoatPassengerEjection")
        @Config.Comment(value={"Prevents underwater boat passengers from being ejected after 60 ticks (3 seconds)."})
        public boolean preventUnderwaterBoatPassengerEjection = RPStaticConfig.Defaults.PREVENT_UNDERWATER_BOAT_PASSENGER_EJECTION;
        @Config.LangKey(value="randompatches.config.boats.underwaterBoatBuoyancy")
        @Config.Comment(value={"The buoyancy of boats when they are under flowing water.\nThe vanilla default is -0.0007."})
        public double underwaterBoatBuoyancy = 0.023;
    }
}

