/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import com.therandomlabs.randompatches.config.RPStaticConfig;
import com.therandomlabs.randompatches.core.Patch;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import org.apache.commons.codec.binary.Base64;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class NBTTagCompoundPatch
extends Patch {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

    @Override
    public boolean apply(ClassNode node) {
        MethodNode method = NBTTagCompoundPatch.findMethod(node, "equals");
        MethodInsnNode entrySet1 = null;
        MethodInsnNode entrySet2 = null;
        MethodInsnNode equals = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            int opcode = instruction.getOpcode();
            if (opcode != 184 && opcode != 185) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
            if (entrySet1 == null) {
                if (!"entrySet".equals(methodInsnNode.name)) continue;
                entrySet1 = methodInsnNode;
                continue;
            }
            if (entrySet2 == null) {
                if (!"entrySet".equals(methodInsnNode.name)) continue;
                entrySet2 = methodInsnNode;
                continue;
            }
            if (!"equals".equals(methodInsnNode.name)) continue;
            equals = methodInsnNode;
            break;
        }
        method.instructions.remove(entrySet1);
        method.instructions.remove(entrySet2);
        equals.setOpcode(184);
        equals.owner = NBTTagCompoundPatch.getName(NBTTagCompoundPatch.class);
        equals.name = "areTagMapsEqual";
        equals.desc = "(Ljava/util/Map;Ljava/util/Map;)Z";
        equals.itf = false;
        return true;
    }

    public static boolean areTagMapsEqual(Map<String, NBTBase> tagMap1, Map<String, NBTBase> tagMap2) {
        GameProfile profile2;
        if (tagMap1.entrySet().equals(tagMap2.entrySet())) {
            return true;
        }
        NBTBase skullOwner1 = tagMap1.get("SkullOwner");
        if (skullOwner1 == null) {
            return false;
        }
        NBTBase skullOwner2 = tagMap2.get("SkullOwner");
        if (skullOwner2 == null) {
            return false;
        }
        GameProfile profile1 = NBTUtil.func_152459_a((NBTTagCompound)((NBTTagCompound)skullOwner1));
        if (!profile1.equals((Object)(profile2 = NBTUtil.func_152459_a((NBTTagCompound)((NBTTagCompound)skullOwner2))))) {
            return false;
        }
        if (!RPStaticConfig.skullStackingRequiresSameTextures) {
            return true;
        }
        MinecraftProfileTexture texture1 = NBTTagCompoundPatch.getSkin(profile1);
        MinecraftProfileTexture texture2 = NBTTagCompoundPatch.getSkin(profile2);
        return texture1 != null && texture2 != null && texture1.getUrl().equals(texture2.getUrl());
    }

    public static MinecraftTexturesPayload getTextures(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return null;
        }
        String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), Charsets.UTF_8);
        return (MinecraftTexturesPayload)GSON.fromJson(json, MinecraftTexturesPayload.class);
    }

    public static MinecraftProfileTexture getSkin(GameProfile profile) {
        MinecraftTexturesPayload payload = NBTTagCompoundPatch.getTextures(profile);
        return payload == null ? null : (MinecraftProfileTexture)payload.getTextures().get(MinecraftProfileTexture.Type.SKIN);
    }
}

