/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.client;

import c4.colytra.common.config.ConfigHandler;
import c4.colytra.network.CPacketToggleColytra;
import c4.colytra.network.NetworkHandler;
import c4.colytra.proxy.CommonProxy;
import c4.colytra.util.ClientUtil;
import c4.colytra.util.ColytraUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerClient {
    @SubscribeEvent
    public void onToggleColytra(InputEvent.KeyInputEvent e) {
        ItemStack stack;
        if (ClientUtil.toggleColytra.func_151468_f() && ColytraUtil.hasElytraUpgrade(stack = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST))) {
            NBTTagCompound compound = stack.func_179543_a("Elytra Upgrade");
            if (compound == null) {
                return;
            }
            int isActive = compound.func_74762_e("Active");
            NetworkHandler.INSTANCE.sendToServer((IMessage)new CPacketToggleColytra(isActive));
        }
    }

    @SubscribeEvent
    public void tooltipHandler(ItemTooltipEvent e) {
        ItemStack itemstack = e.getItemStack();
        if (ColytraUtil.hasElytraUpgrade(itemstack)) {
            NBTTagCompound compound = itemstack.func_179543_a("Elytra Upgrade");
            if (compound == null) {
                return;
            }
            boolean isActive = compound.func_74762_e("Active") == 1;
            int durability = compound.func_74762_e("Durability");
            List tooltip = e.getToolTip();
            Style style = new Style().func_150238_a(TextFormatting.GRAY);
            if (isActive) {
                style = style.func_150238_a(TextFormatting.AQUA);
            }
            ITextComponent tip = new TextComponentTranslation("item.elytra.name", new Object[0]).func_150255_a(style);
            if (ConfigHandler.durabilityMode == ConfigHandler.DurabilityMode.NORMAL) {
                if (durability > 1) {
                    tooltip.add(tip.func_150258_a(": " + durability + "/432").func_150254_d());
                } else {
                    tooltip.add(tip.func_150258_a(": " + new TextComponentTranslation("tooltip.colytra.broken", new Object[0])).func_150254_d());
                }
            } else {
                tooltip.add(tip.func_150254_d());
            }
            if (CommonProxy.quarkLoaded && itemstack.func_77978_p() != null) {
                EventHandlerClient.addElytraColorTooltip(e, itemstack.func_77978_p());
            }
        }
    }

    @Optional.Method(modid="quark")
    private static void addElytraColorTooltip(ItemTooltipEvent evt, NBTTagCompound compound) {
        int color;
        EnumDyeColor dye;
        if (compound.func_74764_b("quark:elytraDye") && (dye = EnumDyeColor.func_176766_a((int)(color = compound.func_74762_e("quark:elytraDye")))) != EnumDyeColor.WHITE) {
            evt.getToolTip().add(I18n.func_135052_a((String)"quark.dyedElytra", (Object[])new Object[]{I18n.func_135052_a((String)("quark.dye." + dye.func_176762_d()), (Object[])new Object[0])}));
        }
    }
}

