/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.util;

import baubles.api.BaublesApi;
import c4.colytra.common.config.ConfigHandler;
import c4.colytra.common.items.ItemElytraBauble;
import c4.colytra.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public class ColytraUtil {
    public static List<Item> itemList;

    public static ItemStack wornElytra(EntityLivingBase entityLivingBase) {
        ItemStack bauble;
        ItemStack chestplate = ColytraUtil.wornColytra(entityLivingBase);
        if (chestplate != ItemStack.field_190927_a) {
            return chestplate;
        }
        if (CommonProxy.baublesLoaded && (bauble = ColytraUtil.wornElytraBauble(entityLivingBase)) != ItemStack.field_190927_a) {
            return bauble;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack wornColytra(EntityLivingBase entityLivingBase) {
        ItemStack chestplate = entityLivingBase.func_184582_a(EntityEquipmentSlot.CHEST);
        return ColytraUtil.hasElytraUpgrade(chestplate) ? chestplate : ItemStack.field_190927_a;
    }

    public static boolean isUsable(ItemStack itemstack) {
        if (ColytraUtil.hasElytraUpgrade(itemstack)) {
            NBTTagCompound compound = itemstack.func_179543_a("Elytra Upgrade");
            if (compound == null) {
                return false;
            }
            int durability = compound.func_74762_e("Durability");
            boolean isActive = compound.func_74762_e("Active") == 1;
            switch (ConfigHandler.durabilityMode) {
                case INFINITE: {
                    return isActive;
                }
                case CHESTPLATE: {
                    IEnergyStorage energyStorage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage != null && energyStorage.getEnergyStored() > 0) {
                        return isActive;
                    }
                    return itemstack.func_77984_f() && itemstack.func_77952_i() < itemstack.func_77958_k() - 1 && isActive;
                }
            }
            return durability > 1 && isActive;
        }
        return itemstack.func_77952_i() < itemstack.func_77958_k() - 1;
    }

    public static boolean hasElytraUpgrade(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Elytra Upgrade");
    }

    public static void initConfigItemList() {
        itemList = new ArrayList<Item>();
        if (ConfigHandler.itemList.length > 0) {
            for (String s : ConfigHandler.itemList) {
                Item item = Item.func_111206_d((String)s);
                if (item == null) continue;
                itemList.add(item);
            }
        }
    }

    @Optional.Method(modid="baubles")
    public static ItemStack wornElytraBauble(EntityLivingBase entity) {
        EntityPlayer player;
        ItemStack stack;
        if (entity instanceof EntityPlayer && (stack = BaublesApi.getBaublesHandler((EntityPlayer)(player = (EntityPlayer)entity)).getStackInSlot(5)).func_77973_b() instanceof ItemElytraBauble) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

