/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.entity;

import codechicken.lib.math.MathHelper;
import codechicken.lib.texture.TextureUtils;
import java.util.ArrayList;
import java.util.Random;
import morph.avaritia.client.ColourHelper;
import morph.avaritia.client.render.entity.ModelRendererWing;
import morph.avaritia.client.render.shader.CosmicShaderHelper;
import morph.avaritia.init.AvaritiaTextures;
import morph.avaritia.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelArmorInfinity
extends ModelBiped {
    public static final ModelArmorInfinity armorModel = new ModelArmorInfinity(1.0f);
    public static final ModelArmorInfinity legModel = new ModelArmorInfinity(0.5f).setLegs(true);
    public static ResourceLocation eyeTex = new ResourceLocation("avaritia", "textures/models/infinity_armor_eyes.png");
    public static ResourceLocation wingTex = new ResourceLocation("avaritia", "textures/models/infinity_armor_wing.png");
    public static ResourceLocation wingGlowTex = new ResourceLocation("avaritia", "textures/models/infinity_armor_wingglow.png");
    public static int itempagewidth = 0;
    public static int itempageheight = 0;
    public boolean legs = false;
    public EntityEquipmentSlot currentSlot = EntityEquipmentSlot.HEAD;
    private Random randy = new Random();
    private Overlay overlay;
    private Overlay invulnOverlay;
    private boolean invulnRender = true;
    private boolean showHat;
    private boolean showChest;
    private boolean showLeg;
    private boolean showFoot;
    private float expand;
    public ModelRenderer bipedLeftWing;
    public ModelRenderer bipedRightWing;

    public ModelArmorInfinity(float expand) {
        super(expand, 0.0f, 64, 64);
        this.expand = expand;
        this.overlay = new Overlay(this, expand);
        this.invulnOverlay = new Overlay(this, 0.0f);
        this.field_178720_f = new ModelRenderer((ModelBase)this, 32, 0);
        this.field_178720_f.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, expand * 0.5f);
        this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public ModelArmorInfinity setLegs(boolean islegs) {
        this.legs = islegs;
        boolean heightoffset = false;
        int legoffset = islegs ? 32 : 0;
        this.field_78115_e = new ModelRenderer((ModelBase)this, 16, 16 + legoffset);
        this.field_78115_e.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, this.expand);
        this.field_78115_e.func_78793_a(0.0f, 0.0f + (float)heightoffset, 0.0f);
        this.field_178721_j = new ModelRenderer((ModelBase)this, 0, 16 + legoffset);
        this.field_178721_j.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, this.expand);
        this.field_178721_j.func_78793_a(-1.9f, 12.0f + (float)heightoffset, 0.0f);
        this.field_178722_k = new ModelRenderer((ModelBase)this, 0, 16 + legoffset);
        this.field_178722_k.field_78809_i = true;
        this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, this.expand);
        this.field_178722_k.func_78793_a(1.9f, 12.0f + (float)heightoffset, 0.0f);
        return this;
    }

    public void rebuildWings() {
        if (this.field_78115_e.field_78805_m == null) {
            this.field_78115_e.field_78805_m = new ArrayList();
        }
        if (this.bipedLeftWing != null) {
            this.field_78115_e.field_78805_m.remove(this.bipedLeftWing);
        }
        if (this.bipedRightWing != null) {
            this.field_78115_e.field_78805_m.remove(this.bipedRightWing);
        }
        this.bipedLeftWing = new ModelRendererWing((ModelBase)this, 0, 0);
        this.bipedLeftWing.field_78809_i = true;
        this.bipedLeftWing.func_78789_a(0.0f, -11.6f, 0.0f, 0, 32, 32);
        this.bipedLeftWing.func_78793_a(-1.5f, 0.0f, 2.0f);
        this.bipedLeftWing.field_78796_g = 1.2566371f;
        this.field_78115_e.func_78792_a(this.bipedLeftWing);
        this.bipedRightWing = new ModelRendererWing((ModelBase)this, 0, 0);
        this.bipedRightWing.func_78789_a(0.0f, -11.6f, 0.0f, 0, 32, 32);
        this.bipedRightWing.func_78793_a(1.5f, 0.0f, 2.0f);
        this.bipedRightWing.field_78796_g = -1.2566371f;
        this.field_78115_e.func_78792_a(this.bipedRightWing);
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean isFlying = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b && entity.field_70160_al;
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CosmicShaderHelper.useShader();
        TextureUtils.bindBlockTexture();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)false);
        if (this.invulnRender) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            this.invulnOverlay.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        }
        this.overlay.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        CosmicShaderHelper.releaseShader();
        mc.field_71446_o.func_110577_a(eyeTex);
        GlStateManager.func_179140_f();
        mc.field_71460_t.func_175072_h();
        long time = mc.field_71439_g.field_70170_p.func_72820_D();
        this.setGems();
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        GlStateManager.func_179131_c((float)0.84f, (float)1.0f, (float)0.95f, (float)((float)(pulse_mag_sqr * 0.5)));
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        if (this.invulnRender) {
            long frame = time / 3L;
            this.randy.setSeed(frame * 1723609L);
            float o = this.randy.nextFloat() * 6.0f;
            float[] col = ColourHelper.HSVtoRGB(o, 1.0f, 1.0f);
            GlStateManager.func_179131_c((float)col[0], (float)col[1], (float)col[2], (float)1.0f);
            this.setEyes();
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        }
        if (!CosmicShaderHelper.inventoryRender) {
            mc.field_71460_t.func_180436_i();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isFlying && !CosmicShaderHelper.inventoryRender) {
            this.setWings();
            mc.field_71446_o.func_110577_a(wingTex);
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            CosmicShaderHelper.useShader();
            TextureUtils.bindBlockTexture();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            this.overlay.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            CosmicShaderHelper.releaseShader();
            mc.field_71446_o.func_110577_a(wingGlowTex);
            GlStateManager.func_179140_f();
            mc.field_71460_t.func_175072_h();
            GlStateManager.func_179131_c((float)0.84f, (float)1.0f, (float)0.95f, (float)((float)(pulse_mag_sqr * 0.5)));
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            if (!CosmicShaderHelper.inventoryRender) {
                mc.field_71460_t.func_180436_i();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void update(EntityLivingBase entityLiving, ItemStack itemstack, EntityEquipmentSlot armorSlot) {
        boolean hasFoot;
        this.currentSlot = armorSlot;
        this.invulnRender = false;
        ItemStack hat = entityLiving.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entityLiving.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack leg = entityLiving.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack foot = entityLiving.func_184582_a(EntityEquipmentSlot.FEET);
        boolean hasHat = hat != null && hat.func_77973_b() == ModItems.infinity_helmet;
        boolean hasChest = chest != null && chest.func_77973_b() == ModItems.infinity_chestplate;
        boolean hasLeg = leg != null && leg.func_77973_b() == ModItems.infinity_pants;
        boolean bl = hasFoot = foot != null && foot.func_77973_b() == ModItems.infinity_boots;
        if (armorSlot == EntityEquipmentSlot.HEAD && hasHat && hasChest && hasLeg && hasFoot) {
            this.invulnRender = true;
        }
        this.showHat = hasHat && armorSlot == EntityEquipmentSlot.HEAD;
        this.showChest = hasChest && armorSlot == EntityEquipmentSlot.CHEST;
        this.showLeg = hasLeg && armorSlot == EntityEquipmentSlot.LEGS;
        this.showFoot = hasFoot && armorSlot == EntityEquipmentSlot.FEET;
        this.field_78116_c.field_78806_j = this.showHat;
        this.field_178720_f.field_78806_j = this.showHat;
        this.field_78115_e.field_78806_j = this.showChest || this.showLeg;
        this.field_178723_h.field_78806_j = this.showChest;
        this.field_178724_i.field_78806_j = this.showChest;
        this.field_178721_j.field_78806_j = this.showLeg || this.showFoot;
        this.field_178722_k.field_78806_j = this.showLeg || this.showFoot;
        this.overlay.field_78116_c.field_78806_j = this.showHat;
        this.overlay.field_178720_f.field_78806_j = this.showHat;
        this.overlay.field_78115_e.field_78806_j = this.showChest || this.showLeg;
        this.overlay.field_178723_h.field_78806_j = this.showChest;
        this.overlay.field_178724_i.field_78806_j = this.showChest;
        this.overlay.field_178721_j.field_78806_j = this.showLeg || this.showFoot;
        this.overlay.field_178722_k.field_78806_j = this.showLeg || this.showFoot;
        this.bipedLeftWing.field_78806_j = false;
        this.bipedRightWing.field_78806_j = false;
        this.overlay.bipedLeftWing.field_78806_j = false;
        this.overlay.bipedRightWing.field_78806_j = false;
        this.field_78117_n = entityLiving.func_70093_af();
        this.field_78093_q = entityLiving.func_184218_aH();
        this.field_78091_s = entityLiving.func_70631_g_();
        this.overlay.field_78117_n = entityLiving.func_70093_af();
        this.overlay.field_78093_q = entityLiving.func_184218_aH();
        this.overlay.field_78091_s = entityLiving.func_70631_g_();
        this.invulnOverlay.field_78117_n = entityLiving.func_70093_af();
        this.invulnOverlay.field_78093_q = entityLiving.func_184218_aH();
        this.invulnOverlay.field_78091_s = entityLiving.func_70631_g_();
        this.overlay.field_78095_p = this.field_78095_p;
        this.invulnOverlay.field_78095_p = this.field_78095_p;
        this.field_187075_l = ModelBiped.ArmPose.EMPTY;
        this.field_187076_m = ModelBiped.ArmPose.EMPTY;
        this.overlay.field_187075_l = ModelBiped.ArmPose.EMPTY;
        this.overlay.field_187076_m = ModelBiped.ArmPose.EMPTY;
        this.invulnOverlay.field_187075_l = ModelBiped.ArmPose.EMPTY;
        this.invulnOverlay.field_187076_m = ModelBiped.ArmPose.EMPTY;
        if (entityLiving instanceof EntityPlayer) {
            ItemStack off_hand;
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack main_hand = player.func_184586_b(EnumHand.MAIN_HAND);
            if (main_hand != null) {
                this.field_187076_m = ModelBiped.ArmPose.ITEM;
                this.overlay.field_187076_m = ModelBiped.ArmPose.ITEM;
                this.invulnOverlay.field_187076_m = ModelBiped.ArmPose.ITEM;
                if (player.func_184605_cv() > 0) {
                    EnumAction enumaction = main_hand.func_77975_n();
                    if (enumaction == EnumAction.BOW) {
                        this.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                        this.overlay.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                        this.invulnOverlay.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    } else if (enumaction == EnumAction.BLOCK) {
                        this.field_187076_m = ModelBiped.ArmPose.BLOCK;
                        this.overlay.field_187076_m = ModelBiped.ArmPose.BLOCK;
                        this.invulnOverlay.field_187076_m = ModelBiped.ArmPose.BLOCK;
                    }
                }
            }
            if ((off_hand = player.func_184586_b(EnumHand.OFF_HAND)) != null) {
                this.field_187075_l = ModelBiped.ArmPose.ITEM;
                this.overlay.field_187075_l = ModelBiped.ArmPose.ITEM;
                this.invulnOverlay.field_187075_l = ModelBiped.ArmPose.ITEM;
                if (player.func_184605_cv() > 0) {
                    EnumAction enumaction = off_hand.func_77975_n();
                    if (enumaction == EnumAction.BOW) {
                        this.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                        this.overlay.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                        this.invulnOverlay.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                    } else if (enumaction == EnumAction.BLOCK) {
                        this.field_187075_l = ModelBiped.ArmPose.BLOCK;
                        this.overlay.field_187075_l = ModelBiped.ArmPose.BLOCK;
                        this.invulnOverlay.field_187075_l = ModelBiped.ArmPose.BLOCK;
                    }
                }
            }
        }
    }

    public void func_78087_a(float f1, float speed, float ticks, float headYaw, float headPitch, float f6, Entity entity) {
        Render r;
        super.func_78087_a(f1, speed, ticks, headYaw, headPitch, f6, entity);
        this.overlay.func_78087_a(f1, speed, ticks, headYaw, headPitch, f6, entity);
        this.invulnOverlay.func_78087_a(f1, speed, ticks, headYaw, headPitch, f6, entity);
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        if (manager.field_78729_o.containsKey(entity.getClass()) && (r = (Render)manager.field_78729_o.get(entity.getClass())) instanceof RenderBiped) {
            ModelBiped m = (ModelBiped)((RenderBiped)r).func_177087_b();
            ModelArmorInfinity.copyBipedAngles(m, this);
        }
    }

    public void setEyes() {
        this.field_78116_c.field_78806_j = false;
        this.field_78115_e.field_78806_j = false;
        this.field_178723_h.field_78806_j = false;
        this.field_178724_i.field_78806_j = false;
        this.field_178721_j.field_78806_j = false;
        this.field_178722_k.field_78806_j = false;
        this.field_178720_f.field_78806_j = this.showHat;
    }

    public void setGems() {
        this.field_78116_c.field_78806_j = false;
        this.field_178720_f.field_78806_j = false;
        boolean bl = this.legs ? false : (this.field_78115_e.field_78806_j = this.showChest);
        boolean bl2 = this.legs ? false : (this.field_178723_h.field_78806_j = this.showChest);
        boolean bl3 = this.legs ? false : (this.field_178724_i.field_78806_j = this.showChest);
        boolean bl4 = this.legs ? this.showLeg : (this.field_178721_j.field_78806_j = false);
        this.field_178722_k.field_78806_j = this.legs ? this.showLeg : false;
    }

    public void setWings() {
        this.field_78115_e.field_78806_j = this.legs ? false : this.showChest;
        this.bipedLeftWing.field_78806_j = true;
        this.bipedRightWing.field_78806_j = true;
        this.field_178720_f.field_78806_j = false;
        this.field_178723_h.field_78806_j = false;
        this.field_178724_i.field_78806_j = false;
        this.field_178721_j.field_78806_j = false;
        this.field_178722_k.field_78806_j = false;
        this.field_178720_f.field_78806_j = false;
        this.field_78116_c.field_78806_j = false;
        this.overlay.field_78115_e.field_78806_j = this.legs ? false : this.showChest;
        this.overlay.bipedLeftWing.field_78806_j = true;
        this.overlay.bipedRightWing.field_78806_j = true;
        this.overlay.field_78116_c.field_78806_j = false;
        this.overlay.field_178720_f.field_78806_j = false;
    }

    public void rebuildOverlay() {
        this.rebuildWings();
        this.overlay.rebuild(AvaritiaTextures.INFINITY_ARMOR_MASK, AvaritiaTextures.INFINITY_ARMOR_MASK_WINGS);
        this.invulnOverlay.rebuild(AvaritiaTextures.INFINITY_ARMOR_MASK_INV, null);
    }

    public static void copyPartAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    public static void copyBipedAngles(ModelBiped source, ModelBiped dest) {
        ModelArmorInfinity.copyPartAngles(source.field_78115_e, dest.field_78115_e);
        ModelArmorInfinity.copyPartAngles(source.field_78116_c, dest.field_78116_c);
        ModelArmorInfinity.copyPartAngles(source.field_178720_f, dest.field_178720_f);
        ModelArmorInfinity.copyPartAngles(source.field_178724_i, dest.field_178724_i);
        ModelArmorInfinity.copyPartAngles(source.field_178722_k, dest.field_178722_k);
        ModelArmorInfinity.copyPartAngles(source.field_178723_h, dest.field_178723_h);
        ModelArmorInfinity.copyPartAngles(source.field_178721_j, dest.field_178721_j);
    }

    public class Overlay
    extends ModelBiped {
        public ModelArmorInfinity parent;
        public float expand;
        public ModelRenderer bipedLeftWing;
        public ModelRenderer bipedRightWing;

        public Overlay(ModelArmorInfinity parent, float expand) {
            this.parent = parent;
            this.expand = expand;
        }

        public void rebuild(TextureAtlasSprite icon, TextureAtlasSprite wingicon) {
            int ox = MathHelper.floor((float)(icon.func_94209_e() * (float)itempagewidth));
            int oy = MathHelper.floor((float)(icon.func_94206_g() * (float)itempageheight));
            float heightoffset = 0.0f;
            int legoffset = this.parent.legs ? 32 : 0;
            this.field_78090_t = itempagewidth;
            this.field_78089_u = itempageheight;
            this.field_78116_c = new ModelRenderer((ModelBase)this, 0 + ox, 0 + legoffset + oy);
            this.field_78116_c.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, this.expand);
            this.field_78116_c.func_78793_a(0.0f, 0.0f + heightoffset, 0.0f);
            this.field_178720_f = new ModelRenderer((ModelBase)this, 32 + ox, 0 + legoffset + oy);
            this.field_178720_f.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, this.expand * 0.5f);
            this.field_178720_f.func_78793_a(0.0f, 0.0f + heightoffset, 0.0f);
            this.field_78115_e = new ModelRenderer((ModelBase)this, 16 + ox, 16 + legoffset + oy);
            this.field_78115_e.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, this.expand);
            this.field_78115_e.func_78793_a(0.0f, 0.0f + heightoffset, 0.0f);
            this.field_178723_h = new ModelRenderer((ModelBase)this, 40 + ox, 16 + legoffset + oy);
            this.field_178723_h.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, this.expand);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f + heightoffset, 0.0f);
            this.field_178724_i = new ModelRenderer((ModelBase)this, 40 + ox, 16 + legoffset + oy);
            this.field_178724_i.field_78809_i = true;
            this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, this.expand);
            this.field_178724_i.func_78793_a(5.0f, 2.0f + heightoffset, 0.0f);
            this.field_178721_j = new ModelRenderer((ModelBase)this, 0 + ox, 16 + legoffset + oy);
            this.field_178721_j.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, this.expand);
            this.field_178721_j.func_78793_a(-1.9f, 12.0f + heightoffset, 0.0f);
            this.field_178722_k = new ModelRenderer((ModelBase)this, 0 + ox, 16 + legoffset + oy);
            this.field_178722_k.field_78809_i = true;
            this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, this.expand);
            this.field_178722_k.func_78793_a(1.9f, 12.0f + heightoffset, 0.0f);
            if (wingicon != null) {
                int oxw = MathHelper.floor((float)(wingicon.func_94209_e() * (float)itempagewidth));
                int oyw = MathHelper.floor((float)(wingicon.func_94206_g() * (float)itempageheight));
                if (this.field_78115_e.field_78805_m == null) {
                    this.field_78115_e.field_78805_m = new ArrayList();
                }
                if (this.bipedLeftWing != null) {
                    this.field_78115_e.field_78805_m.remove(this.bipedLeftWing);
                }
                if (this.bipedRightWing != null) {
                    this.field_78115_e.field_78805_m.remove(this.bipedRightWing);
                }
                this.bipedLeftWing = new ModelRendererWing((ModelBase)this, oxw, oyw);
                this.bipedLeftWing.field_78809_i = true;
                this.bipedLeftWing.func_78789_a(0.0f, -11.6f, 0.0f, 0, 32, 32);
                this.bipedLeftWing.func_78793_a(-1.5f, 0.0f, 2.0f);
                this.bipedLeftWing.field_78796_g = 1.2566371f;
                this.field_78115_e.func_78792_a(this.bipedLeftWing);
                this.bipedRightWing = new ModelRendererWing((ModelBase)this, oxw, oyw);
                this.bipedRightWing.func_78789_a(0.0f, -11.6f, 0.0f, 0, 32, 32);
                this.bipedRightWing.func_78793_a(1.5f, 0.0f, 2.0f);
                this.bipedRightWing.field_78796_g = -1.2566371f;
                this.field_78115_e.func_78792_a(this.bipedRightWing);
            }
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            ModelArmorInfinity.copyBipedAngles(this.parent, this);
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        }

        public void func_78087_a(float f1, float f2, float f3, float f4, float f5, float f6, Entity entity) {
            Render r;
            super.func_78087_a(f1, f2, f3, f4, f5, f6, entity);
            RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
            if (manager.field_78729_o.containsKey(entity.getClass()) && (r = (Render)manager.field_78729_o.get(entity.getClass())) instanceof RenderBiped) {
                ModelBiped m = (ModelBiped)((RenderBiped)r).func_177087_b();
                ModelArmorInfinity.copyBipedAngles(m, this);
            }
        }
    }
}

