/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.interpolate.position;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/math/interpolate/position/InterpBezier2D;", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "start", "end", "startControl", "endControl", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "absoluteEndControl", "absoluteStartControl", "getEnd", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getEndControl", "getStart", "getStartControl", "get", "i", "", "getBezierComponent", "", "t", "s", "e", "sc", "ec", "librarianlib-1.12.2"})
public final class InterpBezier2D
implements InterpFunction<Vec2d> {
    private final Vec2d absoluteStartControl;
    private final Vec2d absoluteEndControl;
    @NotNull
    private final Vec2d start;
    @NotNull
    private final Vec2d end;
    @NotNull
    private final Vec2d startControl;
    @NotNull
    private final Vec2d endControl;

    @Override
    @NotNull
    public Vec2d get(float i) {
        return new Vec2d(this.getBezierComponent(i, this.start.getX(), this.end.getX(), this.absoluteStartControl.getX(), this.absoluteEndControl.getX()), this.getBezierComponent(i, this.start.getY(), this.end.getY(), this.absoluteStartControl.getY(), this.absoluteEndControl.getY()));
    }

    private final double getBezierComponent(double t, double s, double e, double sc, double ec) {
        double T = 1.0 - t;
        return T * T * T * s + (double)3 * T * T * t * sc + (double)3 * T * t * t * ec + t * t * t * e;
    }

    @NotNull
    public final Vec2d getStart() {
        return this.start;
    }

    @NotNull
    public final Vec2d getEnd() {
        return this.end;
    }

    @NotNull
    public final Vec2d getStartControl() {
        return this.startControl;
    }

    @NotNull
    public final Vec2d getEndControl() {
        return this.endControl;
    }

    @JvmOverloads
    public InterpBezier2D(@NotNull Vec2d start, @NotNull Vec2d end, @NotNull Vec2d startControl, @NotNull Vec2d endControl) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)startControl, (String)"startControl");
        Intrinsics.checkParameterIsNotNull((Object)endControl, (String)"endControl");
        this.start = start;
        this.end = end;
        this.startControl = startControl;
        this.endControl = endControl;
        this.absoluteStartControl = CommonUtilMethods.plus(this.start, this.startControl);
        this.absoluteEndControl = CommonUtilMethods.plus(this.end, this.endControl);
    }

    @JvmOverloads
    public /* synthetic */ InterpBezier2D(Vec2d vec2d, Vec2d vec2d2, Vec2d vec2d3, Vec2d vec2d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vec2d3 = CommonUtilMethods.withY(CommonUtilMethods.div(CommonUtilMethods.minus(vec2d2, vec2d), 2), 0);
        }
        if ((n & 8) != 0) {
            vec2d4 = CommonUtilMethods.withY(CommonUtilMethods.div(CommonUtilMethods.minus(vec2d, vec2d2), 2), 0);
        }
        this(vec2d, vec2d2, vec2d3, vec2d4);
    }

    @JvmOverloads
    public InterpBezier2D(@NotNull Vec2d start, @NotNull Vec2d end, @NotNull Vec2d startControl) {
        this(start, end, startControl, null, 8, null);
    }

    @JvmOverloads
    public InterpBezier2D(@NotNull Vec2d start, @NotNull Vec2d end) {
        this(start, end, null, null, 12, null);
    }

    @Override
    @NotNull
    public InterpFunction<Vec2d> reverse() {
        return InterpFunction.DefaultImpls.reverse(this);
    }

    @Override
    @NotNull
    public List<Vec2d> list(int points) {
        return InterpFunction.DefaultImpls.list(this, points);
    }
}

