/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"MATCHER", "Lkotlin/text/Regex;", "TOKENIZER", "elementsFromArray", "Lkotlin/Function1;", "Lcom/google/gson/JsonArray;", "", "getObject", "Lcom/google/gson/JsonElement;", "key", "", "setObject", "", "Lcom/google/gson/JsonObject;", "el", "librarianlib-1.12.2"})
@JvmName(name="JsonUtil")
public final class JsonUtil {
    private static final Regex MATCHER;
    private static final Regex TOKENIZER;
    private static final Function1<JsonArray, Object> elementsFromArray;

    @Nullable
    public static final JsonElement getObject(@NotNull JsonElement $receiver, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (!MATCHER.matches((CharSequence)key)) {
            return null;
        }
        JsonElement currentElement = $receiver;
        Sequence matched = Regex.findAll$default((Regex)TOKENIZER, (CharSequence)key, (int)0, (int)2, null);
        for (MatchResult match : matched) {
            String m = (String)match.getGroupValues().get(1);
            if (StringsKt.startsWith$default((String)m, (String)"[", (boolean)false, (int)2, null)) {
                if (!currentElement.isJsonArray()) {
                    return null;
                }
                JsonArray arr = currentElement.getAsJsonArray();
                String string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)m, (CharSequence)"["), (CharSequence)"]");
                int ind = Integer.parseInt(string);
                if (arr.size() < ind + 1) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)arr.get(ind), (String)"arr[ind]");
                continue;
            }
            if (!currentElement.isJsonObject()) {
                return null;
            }
            JsonObject obj = currentElement.getAsJsonObject();
            if (!obj.has(m)) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)obj.get(m), (String)"obj[m]");
        }
        return currentElement;
    }

    public static final boolean setObject(@NotNull JsonObject $receiver, @NotNull String key, @NotNull JsonElement el) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)el, (String)"el");
        if (!MATCHER.matches((CharSequence)key)) {
            return false;
        }
        JsonElement currentElement = (JsonElement)$receiver;
        List matched = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)TOKENIZER, (CharSequence)key, (int)0, (int)2, null));
        int max = matched.size() - 1;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)matched)) {
            boolean done;
            int index = indexedValue.component1();
            MatchResult match = (MatchResult)indexedValue.component2();
            String m = (String)match.getGroupValues().get(1);
            boolean bl = done = index == max;
            if (StringsKt.startsWith$default((String)m, (String)"[", (boolean)false, (int)2, null)) {
                String string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)m, (CharSequence)"["), (CharSequence)"]");
                int ind = Integer.parseInt(string);
                if (currentElement instanceof JsonArray) {
                    if (((JsonArray)currentElement).size() < ind + 1 && !done) {
                        JsonElement jsonElement = StringsKt.startsWith$default((String)((String)((MatchResult)matched.get(index + 1)).getGroupValues().get(1)), (String)"[", (boolean)false, (int)2, null) ? (JsonElement)new JsonArray() : (JsonElement)new JsonObject();
                        ((JsonArray)currentElement).add(jsonElement);
                        currentElement = jsonElement;
                        continue;
                    }
                    if (!done) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)((JsonArray)currentElement).get(ind), (String)"currentElement[ind]");
                        continue;
                    }
                    if (ind > ((JsonArray)currentElement).size()) {
                        ((JsonArray)currentElement).add(el);
                        continue;
                    }
                    Object object = elementsFromArray.invoke((Object)currentElement);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<com.google.gson.JsonElement>");
                    }
                    List elements = TypeIntrinsics.asMutableList((Object)object);
                    elements.set(ind, el);
                    continue;
                }
                return false;
            }
            if (currentElement instanceof JsonObject) {
                if (!((JsonObject)currentElement).has(m) && !done) {
                    JsonElement jsonElement = StringsKt.startsWith$default((String)((String)((MatchResult)matched.get(index + 1)).getGroupValues().get(1)), (String)"[", (boolean)false, (int)2, null) ? (JsonElement)new JsonArray() : (JsonElement)new JsonObject();
                    ((JsonObject)currentElement).add(m, jsonElement);
                    currentElement = jsonElement;
                    continue;
                }
                if (!done) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)((JsonObject)currentElement).get(m), (String)"currentElement.get(m)");
                    continue;
                }
                ((JsonObject)currentElement).add(m, el);
                continue;
            }
            return false;
        }
        return true;
    }

    static {
        String string = "(?:(?:(?:\\[\\d+\\])|(?:[^.\\[\\]]+))(\\.|$|(?=\\[)))+";
        MATCHER = new Regex(string);
        string = "((?:\\[\\d+\\])|(?:[^.\\[\\]]+))(?=[.\\[]|$)";
        TOKENIZER = new Regex(string);
        elementsFromArray = MethodHandleHelper.wrapperForGetter(JsonArray.class, "elements");
    }
}

