/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.fluids;

import al132.alchemistry.Reference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u000b\u001a\u00020\u0005\"\f\b\u0000\u0010\f*\u00020\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\f0\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u0017R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lal132/alchemistry/fluids/ModFluids;", "", "()V", "FLUIDS", "", "Lnet/minecraftforge/fluids/Fluid;", "getFLUIDS", "()Ljava/util/Set;", "MOD_FLUID_BLOCKS", "Lnet/minecraftforge/fluids/IFluidBlock;", "getMOD_FLUID_BLOCKS", "createFluid", "T", "Lnet/minecraft/block/Block;", "name", "", "hasFlowIcon", "", "fluidPropertyApplier", "Ljava/util/function/Consumer;", "blockFactory", "Ljava/util/function/Function;", "registerBucket", "", "fluid", "registerFluidContainers", "RegistrationHandler", "alchemistry"})
public final class ModFluids {
    @NotNull
    private static final Set<Fluid> FLUIDS;
    @NotNull
    private static final Set<IFluidBlock> MOD_FLUID_BLOCKS;
    public static final ModFluids INSTANCE;

    @NotNull
    public final Set<Fluid> getFLUIDS() {
        return FLUIDS;
    }

    @NotNull
    public final Set<IFluidBlock> getMOD_FLUID_BLOCKS() {
        return MOD_FLUID_BLOCKS;
    }

    private final <T extends Block> Fluid createFluid(String name, boolean hasFlowIcon, Consumer<Fluid> fluidPropertyApplier, Function<Fluid, T> blockFactory) {
        ResourceLocation flowing;
        String texturePrefix = Reference.INSTANCE.getPathPrefix() + "fluids/";
        ResourceLocation still = new ResourceLocation(texturePrefix + name + "_still");
        Fluid fluid = new Fluid(name, still, flowing = hasFlowIcon ? new ResourceLocation(texturePrefix + name + "_flow") : still);
        boolean useOwnFluid = FluidRegistry.registerFluid((Fluid)fluid);
        if (useOwnFluid) {
            fluidPropertyApplier.accept(fluid);
            T t = blockFactory.apply(fluid);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"blockFactory.apply(fluid)");
            MOD_FLUID_BLOCKS.add((IFluidBlock)t);
        } else {
            Fluid fluid2 = FluidRegistry.getFluid((String)name);
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"FluidRegistry.getFluid(name)");
            fluid = fluid2;
        }
        FLUIDS.add(fluid);
        return fluid;
    }

    public final void registerFluidContainers() {
        Iterable $receiver$iv = FLUIDS;
        for (Object element$iv : $receiver$iv) {
            Fluid it = (Fluid)element$iv;
            INSTANCE.registerBucket(it);
        }
    }

    private final void registerBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    private ModFluids() {
    }

    static {
        ModFluids modFluids;
        INSTANCE = modFluids = new ModFluids();
        FLUIDS = new HashSet();
        MOD_FLUID_BLOCKS = new HashSet();
    }

    @Mod.EventBusSubscriber
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007\u00a8\u0006\n"}, d2={"Lal132/alchemistry/fluids/ModFluids$RegistrationHandler;", "", "()V", "registerBlocks", "", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/block/Block;", "registerItems", "Lnet/minecraft/item/Item;", "alchemistry"})
    public static final class RegistrationHandler {
        public static final RegistrationHandler INSTANCE;

        @SubscribeEvent
        public final void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            IForgeRegistry registry = event.getRegistry();
            Iterator<IFluidBlock> iterator = INSTANCE.getMOD_FLUID_BLOCKS().iterator();
            while (iterator.hasNext()) {
                IFluidBlock fluidBlock;
                IFluidBlock iFluidBlock = fluidBlock = iterator.next();
                if (iFluidBlock == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.block.Block");
                }
                Block block = (Block)iFluidBlock;
                StringBuilder stringBuilder = new StringBuilder().append("fluid.");
                Fluid fluid = fluidBlock.getFluid();
                Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"fluidBlock.fluid");
                block.setRegistryName("alchemistry", stringBuilder.append(fluid.getName()).toString());
                StringBuilder stringBuilder2 = new StringBuilder().append(Reference.INSTANCE.getPathPrefix());
                Fluid fluid2 = fluidBlock.getFluid();
                Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"fluidBlock.fluid");
                block.func_149663_c(stringBuilder2.append(fluid2.getUnlocalizedName()).toString());
                block.func_149647_a(Reference.INSTANCE.getCreativeTab());
                registry.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public final void registerItems(@NotNull RegistryEvent.Register<Item> event) {
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            IForgeRegistry registry = event.getRegistry();
            Iterator<IFluidBlock> iterator = INSTANCE.getMOD_FLUID_BLOCKS().iterator();
            while (iterator.hasNext()) {
                IFluidBlock fluidBlock;
                IFluidBlock iFluidBlock = fluidBlock = iterator.next();
                if (iFluidBlock == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.block.Block");
                }
                Block block = (Block)iFluidBlock;
                ItemBlock itemBlock = new ItemBlock(block);
                ResourceLocation resourceLocation = block.getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                itemBlock.setRegistryName(resourceLocation);
                registry.register((IForgeRegistryEntry)itemBlock);
            }
        }

        private RegistrationHandler() {
        }

        static {
            RegistrationHandler registrationHandler;
            INSTANCE = registrationHandler = new RegistrationHandler();
        }
    }
}

