/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffect;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffectRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class MGuiEffectRenderer
extends MGuiElementBase<MGuiEffectRenderer> {
    public static final ResourceLocation VANILLA_PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    private final GuiEffectRenderer effectRenderer = new GuiEffectRenderer();
    private ResourceLocation particleTexture = null;

    public MGuiEffectRenderer setParticleTexture(ResourceLocation particleTexture) {
        this.particleTexture = particleTexture;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.particleTexture != null) {
            ResourceHelperBC.bindTexture(this.particleTexture);
        }
        this.effectRenderer.renderEffects(partialTicks);
    }

    @Override
    public boolean onUpdate() {
        this.effectRenderer.updateEffects();
        return super.onUpdate();
    }

    public MGuiEffectRenderer addEffect(GuiEffect effect) {
        effect.zLevel = this.getRenderZLevel();
        this.effectRenderer.addEffect(effect);
        return this;
    }

    public void clearEffects() {
        this.effectRenderer.clearEffects();
    }

    @Override
    public MGuiEffectRenderer translate(int xAmount, int yAmount) {
        this.effectRenderer.getActiveEffects().forEach(guiEffect -> guiEffect.moveEntity(xAmount, yAmount));
        return (MGuiEffectRenderer)super.translate(xAmount, yAmount);
    }
}

