/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainerTable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders.PartBuilderEntity;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders.PartBuilderImage;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders.PartBuilderLink;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders.PartBuilderRecipe;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders.PartBuilderText;
import com.brandon3055.brandonscore.utils.OldProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class GuiMarkdownElement
extends MGuiElementBase<GuiMarkdownElement> {
    public static Pattern obf = Pattern.compile("(?<=[^\\\\]|^)(~\\?~.*~\\?~)");
    public static Pattern bold = Pattern.compile("(?<=[^\\\\]|^)(\\*\\*.*\\*\\*)");
    public static Pattern italic = Pattern.compile("(?<=[^\\\\]|^)(\\*.*\\*)");
    public static Pattern strike = Pattern.compile("(?<=[^\\\\]|^)(~~.*~~)");
    public static Pattern tablePat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7table\\[[^]]*])");
    public static Pattern underline = Pattern.compile("(?<=[^\\\\]|^)(__.*__)");
    public static Pattern colourPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7colour\\[[^]]*])");
    public static Pattern colourExtractPat = Pattern.compile("(?<=\u00a7colour\\[)([^]]*)(?=])");
    public static OldProfiler profiler = new OldProfiler();
    protected static LinkedList<IPartBuilder> partBuilders = new LinkedList();
    public String imageDLFailedMessage = "Image Download Failed!";
    private boolean reloadRequired = false;
    private LinkedList<String> mlCache = null;
    private List<PartContainer> containers = new ArrayList<PartContainer>();
    protected BiConsumer<String, Integer> linkListener = null;
    protected BiConsumer<String, Integer> imageListener = null;
    protected BiConsumer<ItemStack, Integer> recipeListener = null;
    protected GuiAlign currentAlign = GuiAlign.LEFT;
    protected GuiColourProvider<Integer> colourProvider = () -> 0;

    public GuiMarkdownElement() {
        this.reportYSizeChange = true;
        GuiMarkdownElement.profiler.enabled = false;
    }

    public GuiMarkdownElement parseMarkdown(String markdownSting) {
        String[] lines = markdownSting.split("\n");
        return this.parseMarkdown(lines);
    }

    public GuiMarkdownElement parseMarkdown(String[] markdownLines) {
        return this.parseMarkdown(new LinkedList<String>(Arrays.asList(markdownLines)));
    }

    public GuiMarkdownElement parseMarkdown(LinkedList<String> markdownLines) {
        this.currentAlign = GuiAlign.LEFT;
        markdownLines.removeIf(s -> s.startsWith("//"));
        profiler.startSection("Parsing Markdown");
        this.mlCache = new LinkedList<String>(markdownLines);
        markdownLines = new LinkedList<String>(markdownLines);
        int yPos = this.getInsetRect().y;
        while (markdownLines.size() > 0) {
            profiler.startSection("Create Container");
            PartContainer container = this.createContainer(markdownLines);
            profiler.endStartSection("Populate Container");
            ((PartContainer)container.setPos(this.getInsetRect().x, yPos)).setXSize(this.getInsetRect().width);
            container.parseMarkdown(markdownLines);
            yPos = container.maxYPos();
            this.addChild(container);
            this.containers.add(container);
            profiler.endSection();
        }
        this.setYSize(yPos - this.yPos() + this.getInsets().bottom);
        profiler.endSection();
        profiler.finish();
        return this;
    }

    private PartContainer createContainer(LinkedList<String> markdownLines) {
        PartContainer container;
        profiler.startSection("Get Line");
        String line = markdownLines.getFirst();
        profiler.endSection();
        if (tablePat.matcher(line).find()) {
            profiler.startSection("Create Table Container");
            container = new PartContainerTable(this);
        } else {
            profiler.startSection("Create Normal Container");
            container = new PartContainer(this);
        }
        profiler.endSection();
        return container;
    }

    public void reload() {
        this.reloadRequired = true;
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.reload();
    }

    @Override
    public boolean onUpdate() {
        if (this.reloadRequired) {
            this.reloadRequired = false;
            if (this.mlCache != null) {
                this.toRemove.addAll(this.containers);
                this.containers.clear();
                this.parseMarkdown(this.mlCache);
            }
            return true;
        }
        return super.onUpdate();
    }

    public GuiMarkdownElement setLinkListener(BiConsumer<String, Integer> linkListener) {
        this.linkListener = linkListener;
        return this;
    }

    public GuiMarkdownElement setImageListener(BiConsumer<String, Integer> imageListener) {
        this.imageListener = imageListener;
        return this;
    }

    public GuiMarkdownElement setRecipeListener(BiConsumer<ItemStack, Integer> recipeListener) {
        this.recipeListener = recipeListener;
        return this;
    }

    public int getBaseTextColour() {
        return this.colourProvider.getColour();
    }

    public void setColourProvider(GuiColourProvider<Integer> colourProvider) {
        this.colourProvider = colourProvider;
    }

    public void clear() {
        this.toRemove.addAll(this.containers);
        this.containers.clear();
    }

    static {
        partBuilders.add(new PartBuilderLink());
        partBuilders.add(new PartBuilderImage());
        partBuilders.add(new PartBuilderRecipe());
        partBuilders.add(new PartBuilderEntity());
        partBuilders.add(new PartBuilderText());
    }
}

