/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class PartBuilderImage
extends IPartBuilder {
    private static Pattern imgPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7img\\[[^]]*]\\{[^\u00a7]*})|(?<=[^\\\\]|^)(\u00a7img\\[[^]]*])");
    private static Pattern imgURL = Pattern.compile("(?<=\u00a7img\\[)([^]]*)(?=])");
    private static Pattern imgOPS = Pattern.compile("(?<=]\\{)(.*)(?=})");

    @Override
    public int matches(String test) {
        Matcher matcher = imgPat.matcher(test);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public String build(BCFontRenderer font, String markdown, int nextPart, BCFontRenderer fr, final PartContainer container, LinkedList<Part> parts, int elementLeft, int elementRight, int xPos, int yPos, int nextYLevel) {
        int height;
        int width;
        int bottomPad;
        int topPad;
        int rightPad;
        int leftPad;
        int borderColourHover;
        int borderColour;
        String ops;
        String url;
        GuiMarkdownElement.profiler.startSection("Build Image");
        this.builtHeight = font.field_78288_b;
        Matcher linkMatch = imgPat.matcher(markdown);
        if (!linkMatch.find(0)) {
            LogHelperBC.error("Failed to build " + this.getClass().getSimpleName() + " This suggests a false match occurred which should not be possible!");
            return "";
        }
        String match = linkMatch.group();
        Matcher urlMatch = imgURL.matcher(match);
        if (!urlMatch.find() || (url = urlMatch.group()).isEmpty()) {
            return linkMatch.replaceFirst("[Broken Image. No image URL Found]");
        }
        Matcher opsMatch = imgOPS.matcher(match);
        String string = ops = opsMatch.find() ? opsMatch.group() : "";
        if (ops.toLowerCase().contains("border_colour") || ops.toLowerCase().contains("border_colour_hover")) {
            try {
                borderColour = Part.readColour(Part.readOption(ops, "border_colour", "#FFFFFF"));
                borderColourHover = Part.readColour(Part.readOption(ops, "border_colour_hover", "#" + Integer.toHexString(borderColour)));
            }
            catch (NumberFormatException e) {
                return linkMatch.replaceFirst("[Broken Image. Invalid Colour Value! Must be hex starting with 0x or # or a red,green,blue value]");
            }
        } else {
            borderColour = -1;
            borderColourHover = -1;
        }
        try {
            int padding = Integer.parseInt(Part.readOption(ops, "padding", "0"));
            leftPad = Integer.parseInt(Part.readOption(ops, "left_pad", String.valueOf(padding)));
            rightPad = Integer.parseInt(Part.readOption(ops, "right_pad", String.valueOf(padding)));
            topPad = Integer.parseInt(Part.readOption(ops, "top_pad", String.valueOf(padding)));
            bottomPad = Integer.parseInt(Part.readOption(ops, "bottom_pad", String.valueOf(padding)));
        }
        catch (NumberFormatException e) {
            return linkMatch.replaceFirst("[Broken Image. Invalid padding value! Must be an integer number]");
        }
        try {
            String widthString = Part.readOption(ops, "width", "-1px");
            String heightString = Part.readOption(ops, "height", "-1px");
            int w = Part.parseSize(elementRight - elementLeft, widthString);
            int h = Part.parseSize(elementRight - elementLeft, heightString);
            int maxY = container.getParent() != null ? container.getParent().ySize() : 255;
            width = MathHelper.clip((int)w, (int)-1, (int)container.xSize());
            height = MathHelper.clip((int)h, (int)-1, (int)maxY);
        }
        catch (NumberFormatException e) {
            return linkMatch.replaceFirst("[Broken Image. Invalid width or height value! Must be an integer number]");
        }
        int addWidth = leftPad + rightPad;
        int addHeight = topPad + bottomPad;
        String hover = Part.readOption(ops, "hover", "");
        final String linkTarget = Part.readOption(ops, "link_to", "");
        DLResourceLocation resourceLocation = DLRSCache.getResource(url);
        final MouseIntractable mi = new MouseIntractable(){

            @Override
            public boolean onClick(int mouseX, int mouseY, int button) {
                if (GuiScreen.func_146272_n()) {
                    DLRSCache.clearFileCache(url);
                    return false;
                }
                if (linkTarget.isEmpty()) {
                    container.imageClick(url, button);
                } else {
                    container.linkClick(linkTarget, button);
                }
                return true;
            }
        };
        if (!hover.isEmpty()) {
            if (hover.contains("\\n")) {
                mi.hoverText.addAll(Arrays.asList(hover.split("(\\\\n)")));
            } else {
                mi.hoverText.add(hover);
            }
        }
        container.mouseIntractables.add(mi);
        Part part = new Part(container){

            @Override
            public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                DLResourceLocation resourceLocation = DLRSCache.getResource(url);
                ResourceHelperBC.bindTexture(resourceLocation);
                if (resourceLocation.dlStateChanged()) {
                    this.container.element.reload();
                    return;
                }
                if (resourceLocation.dlFailed) {
                    mi.errorText = this.container.element.imageDLFailedMessage;
                } else if (!resourceLocation.dlFinished) {
                    mi.errorText = "Downloading...";
                } else if (mi.errorText != null) {
                    mi.errorText = null;
                }
                if (borderColour != -1) {
                    int border = mi.isMouseOver ? borderColourHover : borderColour;
                    this.container.drawColouredRect(xPos, yPos, this.width, this.height, 0xFF000000 | border);
                }
                int w = this.width - rightPad - leftPad;
                int h = this.height - bottomPad - topPad;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.container.drawModalRectWithCustomSizedTexture(xPos + leftPad, yPos + topPad, 0.0, 0.0, w, h, w, h);
                GlStateManager.func_179131_c((float)font.field_78291_n, (float)font.field_78292_o, (float)font.field_78306_p, (float)1.0f);
            }
        };
        mi.parts.add(part);
        if (width == -1 && height == -1) {
            width = 28;
        }
        if (width != -1) {
            part.width = width + addWidth;
            if (height == -1) {
                part.height = resourceLocation.sizeSet ? (int)((double)resourceLocation.height / (double)resourceLocation.width * (double)width) + addHeight : width + addHeight;
            }
        }
        if (height != -1) {
            part.height = height + addHeight;
            if (width == -1) {
                part.width = resourceLocation.sizeSet ? (int)((double)resourceLocation.width / (double)resourceLocation.height * (double)height) + addWidth : height + addWidth;
            }
        }
        if (this.finalXPos + width > elementRight) {
            this.finalXPos = elementLeft;
            this.finalYPos = nextYLevel;
        }
        parts.add(part);
        this.finalXPos += width;
        this.builtHeight = this.finalYPos - yPos + part.height + 1;
        return linkMatch.replaceFirst("");
    }
}

