/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders;

import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class PartBuilderLink
extends IPartBuilder {
    private static Pattern linkPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7link\\[[^]]*]\\{[^\u00a7]*})|(?<=[^\\\\]|^)(\u00a7link\\[[^]]*])");
    private static Pattern linkURL = Pattern.compile("(?<=\u00a7link\\[)([^]]*)(?=])");
    private static Pattern linkOPS = Pattern.compile("(?<=]\\{)(.*)(?=})");

    @Override
    public int matches(String test) {
        Matcher matcher = linkPat.matcher(test);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public String build(BCFontRenderer font, String markdown, int nextPart, BCFontRenderer fr, final PartContainer container, LinkedList<Part> parts, int elementLeft, int elementRight, int xPos, int yPos, int nextYLevel) {
        int bottomPad;
        int topPad;
        int rightPad;
        int leftPad;
        int borderColourHover;
        int fillColourHover;
        int borderColour;
        int fillColour;
        String url;
        GuiMarkdownElement.profiler.startSection("Build Link");
        this.builtHeight = font.field_78288_b;
        Matcher linkMatch = linkPat.matcher(markdown);
        if (!linkMatch.find(0)) {
            LogHelperBC.error("Failed to build " + this.getClass().getSimpleName() + " This suggests a false match occurred which should not be possible!");
            return "";
        }
        String match = linkMatch.group();
        Matcher urlMatch = linkURL.matcher(match);
        if (!urlMatch.find() || (url = urlMatch.group()).isEmpty()) {
            return linkMatch.replaceFirst("[Broken Link. No Link Target Found]");
        }
        Matcher opsMatch = linkOPS.matcher(match);
        String ops = opsMatch.find() ? opsMatch.group() : "";
        final String render = Part.readOption(ops, "render", "text").toLowerCase();
        try {
            fillColour = Part.readColour(Part.readOption(ops, "fill_colour", "#000000"));
            borderColour = Part.readColour(Part.readOption(ops, "border_colour", "#FFFFFF"));
            fillColourHover = Part.readColour(Part.readOption(ops, "fill_colour_hover", "#000000"));
            borderColourHover = Part.readColour(Part.readOption(ops, "border_colour_hover", "#FFFFFF"));
        }
        catch (NumberFormatException e) {
            return linkMatch.replaceFirst("[Broken Link. Invalid Colour Value! Must be hex starting with 0x or # or a red,green,blue value]");
        }
        int padding = 2;
        try {
            padding = Integer.parseInt(Part.readOption(ops, "padding", "2"));
            leftPad = Integer.parseInt(Part.readOption(ops, "left_pad", String.valueOf(padding)));
            rightPad = Integer.parseInt(Part.readOption(ops, "right_pad", String.valueOf(padding)));
            topPad = Integer.parseInt(Part.readOption(ops, "top_pad", String.valueOf(padding)));
            bottomPad = Integer.parseInt(Part.readOption(ops, "bottom_pad", String.valueOf(padding)));
        }
        catch (NumberFormatException e) {
            return linkMatch.replaceFirst("[Broken Link. Invalid padding value! Must be an integer number]");
        }
        final String text = Part.readOption(ops, "alt_text", url);
        String hover = Part.readOption(ops, "hover", "");
        final MouseIntractable mi = new MouseIntractable(){

            @Override
            public boolean onClick(int mouseX, int mouseY, int button) {
                container.linkClick(url, button);
                if (render.equals("vanilla") || render.equals("solid")) {
                    container.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
                return true;
            }
        };
        if (!hover.isEmpty()) {
            if (hover.contains("\\n")) {
                mi.hoverText.addAll(Arrays.asList(hover.split("(\\\\n)")));
            } else {
                mi.hoverText.add(hover);
            }
        }
        container.mouseIntractables.add(mi);
        font.func_78265_b();
        BCFontRenderer.setStileToggleMode(true);
        if (render.equals("text")) {
            if (text.length() > 0) {
                LinkedList<String> words = Part.splitOnSpace(text);
                for (String word : words) {
                    char fc;
                    if (word.length() == 0) continue;
                    int maxWordWidth = font.func_78256_a(word);
                    boolean wrapped = false;
                    if (this.finalXPos + maxWordWidth >= elementRight) {
                        this.finalXPos = elementLeft;
                        this.finalYPos = Math.max(this.finalYPos + font.field_78288_b, nextYLevel);
                        wrapped = true;
                    }
                    if (((fc = word.charAt(0)) == ' ' || fc == '\n') && wrapped && word.length() > 0) {
                        word = word.substring(1);
                        boolean bold = font.field_78302_t;
                        maxWordWidth = font.func_78256_a(word);
                        font.field_78302_t = bold;
                    }
                    final String line = word;
                    Part part = new Part(container){

                        @Override
                        public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                            String text = TextFormatting.DARK_BLUE + "" + TextFormatting.UNDERLINE + line + TextFormatting.DARK_BLUE + "" + TextFormatting.UNDERLINE;
                            if (mi.isMouseOver) {
                                text = TextFormatting.ITALIC + text + TextFormatting.ITALIC;
                            }
                            font.func_175065_a(text, xPos, yPos, colour, shadow);
                        }
                    };
                    mi.parts.add(part);
                    part.width = maxWordWidth;
                    part.height = font.field_78288_b;
                    parts.add(part);
                    this.finalXPos += maxWordWidth;
                }
            }
            this.builtHeight = this.finalYPos - yPos + font.field_78288_b + 1;
        } else if (render.equals("vanilla") || render.equals("solid")) {
            int width = font.func_78256_a(text) + leftPad + rightPad;
            Part part = new Part(container){

                @Override
                public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                    if (render.equals("vanilla")) {
                        this.container.renderVanillaButtonTexture(xPos, yPos, this.width, this.height, mi.isMouseOver, false);
                    } else {
                        int fill = mi.isMouseOver ? fillColourHover : fillColour;
                        int border = mi.isMouseOver ? borderColourHover : borderColour;
                        this.container.drawBorderedRect(xPos, yPos, this.width, this.height, 1.0, 0xFF000000 | fill, 0xFF000000 | border);
                    }
                    GlStateManager.func_179131_c((float)font.field_78291_n, (float)font.field_78292_o, (float)font.field_78306_p, (float)1.0f);
                    font.func_175065_a(text, xPos + leftPad, yPos + topPad, colour, shadow);
                }
            };
            mi.parts.add(part);
            part.width = width;
            part.height = font.field_78288_b + topPad + bottomPad;
            parts.add(part);
            this.finalXPos += width;
            this.builtHeight = this.finalYPos - yPos + part.height + 1;
        } else {
            BCFontRenderer.setStileToggleMode(false);
            return linkMatch.replaceFirst("[Broken Link. Invalid Render Type! Valid types are text, vanilla and solid]");
        }
        BCFontRenderer.setStileToggleMode(false);
        return linkMatch.replaceFirst("");
    }
}

