/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;

public class BetterVanillaTextures
extends Feature {
    private static final String OVERRIDES_JSON_FILE = "/assets/quark/overrides.json";
    private static final Gson GSON = new Gson();
    OverrideHolder overrides = null;

    @Override
    public void setupConfig() {
        if (this.overrides == null) {
            InputStreamReader reader = new InputStreamReader(Quark.class.getResourceAsStream(OVERRIDES_JSON_FILE));
            this.overrides = (OverrideHolder)GSON.fromJson((Reader)reader, OverrideHolder.class);
        }
        for (OverrideEntry e : this.overrides.overrides) {
            e.configVal = this.loadPropBool("Enable " + e.name, "", !e.disabled);
        }
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        this.overrides.overrides.forEach(OverrideEntry::apply);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private static class OverrideEntry {
        String name;
        String[] files;
        boolean disabled = false;
        boolean configVal;

        private OverrideEntry() {
        }

        void apply() {
            if (this.configVal) {
                for (String file : this.files) {
                    String[] tokens = file.split("\\/\\/");
                    Quark.proxy.addResourceOverride(tokens[0], tokens[1]);
                }
            }
        }
    }

    private static class OverrideHolder {
        List<OverrideEntry> overrides;

        private OverrideHolder() {
        }
    }
}

