/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.quark.base.module.Feature;

public class MinecartInteraction
extends Feature {
    Map<Item, Function<EntityMinecartEmpty, EntityMinecart>> inserters = new HashMap<Item, Function<EntityMinecartEmpty, EntityMinecart>>();
    boolean enableCommandAndSpawner;

    @Override
    public void setupConfig() {
        this.enableCommandAndSpawner = this.loadPropBool("Enable Command Block and Mob Spawner", "", true);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150486_ae), e -> this.getMinecart(new ResourceLocation("minecraft", "chest_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150335_W), e -> this.getMinecart(new ResourceLocation("minecraft", "tnt_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150460_al), e -> this.getMinecart(new ResourceLocation("minecraft", "furnace_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150438_bZ), e -> this.getMinecart(new ResourceLocation("minecraft", "hopper_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
        if (this.enableCommandAndSpawner) {
            this.inserters.put(Item.func_150898_a((Block)Blocks.field_150483_bI), e -> this.getMinecart(new ResourceLocation("minecraft", "commandblock_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
            this.inserters.put(Item.func_150898_a((Block)Blocks.field_150474_ac), e -> this.getMinecart(new ResourceLocation("minecraft", "spawner_minecart"), e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v));
        }
    }

    EntityMinecart getMinecart(ResourceLocation rl, World world, double x, double y, double z) {
        try {
            Class minecartClass = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(rl)).getEntityClass();
            return (EntityMinecart)minecartClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (target instanceof EntityMinecartEmpty && target.func_184188_bt().isEmpty()) {
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !this.inserters.containsKey(stack.func_77973_b())) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (!stack.func_190926_b() && this.inserters.containsKey(stack.func_77973_b())) {
                EntityMinecart minecart;
                player.func_184609_a(hand);
                if (!event.getWorld().field_72995_K && (minecart = this.inserters.get(stack.func_77973_b()).apply((EntityMinecartEmpty)target)) != null) {
                    target.func_70106_y();
                    event.getWorld().func_72838_d((Entity)minecart);
                    event.setCanceled(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Minecart Block Placement";
    }
}

