/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.model.ModelBiped;
import net.minecraftforge.fml.common.FMLLog;
import vazkii.aurelienribon.tweenengine.Timeline;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.aurelienribon.tweenengine.TweenEquation;
import vazkii.aurelienribon.tweenengine.TweenEquations;
import vazkii.quark.vanity.client.emotes.ModelAccessor;

public class EmoteTemplate {
    private static final Map<String, Integer> parts;
    private static final Map<String, Integer> tweenables;
    private static final Map<String, Function> functions;
    private static final Map<String, TweenEquation> equations;
    final String file;
    List<String> readLines;
    List<Integer> usedParts;
    Stack<Timeline> timelineStack;
    float speed;
    int tier;
    boolean compiled = false;
    boolean compiledOnce = false;

    public EmoteTemplate(String file) {
        this.file = file;
        this.readAndMakeTimeline(null);
    }

    public Timeline getTimeline(ModelBiped model) {
        int i;
        this.compiled = false;
        this.speed = 1.0f;
        this.tier = 0;
        if (this.readLines == null) {
            return this.readAndMakeTimeline(model);
        }
        Timeline timeline = null;
        this.timelineStack = new Stack();
        try {
            for (i = 0; i < this.readLines.size() && !this.compiled; ++i) {
                timeline = this.handle(model, timeline, this.readLines.get(i));
            }
        }
        catch (Exception e) {
            this.logError(e, i);
            return Timeline.createSequence();
        }
        if (timeline == null) {
            return Timeline.createSequence();
        }
        return timeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeline readAndMakeTimeline(ModelBiped model) {
        Timeline timeline = null;
        this.usedParts = new ArrayList<Integer>();
        this.timelineStack = new Stack();
        int lines = 0;
        BufferedReader reader = null;
        this.compiledOnce = false;
        this.compiled = false;
        this.readLines = new ArrayList<String>();
        try {
            Timeline e2;
            reader = this.createReader();
            try {
                String s;
                while ((s = reader.readLine()) != null && !this.compiled) {
                    ++lines;
                    this.readLines.add(s);
                    timeline = this.handle(model, timeline, s);
                }
            }
            catch (Exception e2) {
                this.logError(e2, lines);
                Timeline timeline2 = this.fallback();
                this.compiledOnce = true;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return timeline2;
            }
            if (timeline == null) {
                e2 = this.fallback();
                return e2;
            }
            e2 = timeline;
            return e2;
        }
        catch (IOException e) {
            e.printStackTrace();
            Timeline timeline3 = this.fallback();
            return timeline3;
        }
        finally {
            this.compiledOnce = true;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    BufferedReader createReader() throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(EmoteTemplate.class.getResourceAsStream("/assets/quark/emotes/" + this.file)));
    }

    Timeline fallback() {
        return Timeline.createSequence();
    }

    private void logError(Exception e, int line) {
        FMLLog.log.error("[Quark Custom Emotes] Error loading line " + (line + 1) + " of emote " + this.file);
        if (!(e instanceof IllegalArgumentException)) {
            FMLLog.log.error("[Quark Custom Emotes] This is an Internal Error, and not one in the emote file, please report it");
            e.printStackTrace();
        } else {
            FMLLog.log.error("[Quark Custom Emotes] " + e.getMessage());
        }
    }

    private Timeline handle(ModelBiped model, Timeline timeline, String s) throws IllegalArgumentException {
        if ((s = s.trim()).startsWith("#") || s.isEmpty()) {
            return timeline;
        }
        String[] tokens = s.trim().split(" ");
        String function = tokens[0];
        if (functions.containsKey(function)) {
            return functions.get(function).invoke(this, model, timeline, tokens);
        }
        throw new IllegalArgumentException("Illegal function name " + function);
    }

    void setName(String[] tokens) {
    }

    private static Timeline name(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        em.setName(tokens);
        return timeline;
    }

    private static Timeline use(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        if (em.compiledOnce) {
            return timeline;
        }
        EmoteTemplate.assertParamSize(tokens, 2);
        String part = tokens[1];
        if (!parts.containsKey(part)) {
            throw new IllegalArgumentException("Illgal part name for function use: " + part);
        }
        em.usedParts.add(parts.get(part));
        return timeline;
    }

    private static Timeline unit(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        em.speed = Float.parseFloat(tokens[1]);
        return timeline;
    }

    private static Timeline tier(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        em.tier = Integer.parseInt(tokens[1]);
        return timeline;
    }

    private static Timeline animation(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        String type;
        if (timeline != null) {
            throw new IllegalArgumentException("Illegal use of function animation, animation already started");
        }
        EmoteTemplate.assertParamSize(tokens, 2);
        switch (type = tokens[1]) {
            case "sequence": {
                return Timeline.createSequence();
            }
            case "parallel": {
                return Timeline.createParallel();
            }
        }
        throw new IllegalArgumentException("Illegal animation type: " + type);
    }

    private static Timeline section(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        Timeline newTimeline;
        String type;
        EmoteTemplate.assertParamSize(tokens, 2);
        switch (type = tokens[1]) {
            case "sequence": {
                newTimeline = Timeline.createSequence();
                break;
            }
            case "parallel": {
                newTimeline = Timeline.createParallel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal section type: " + type);
            }
        }
        em.timelineStack.push(timeline);
        return newTimeline;
    }

    private static Timeline end(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 1);
        if (em.timelineStack.isEmpty()) {
            em.compiled = true;
            return timeline;
        }
        Timeline poppedLine = em.timelineStack.pop();
        poppedLine.push(timeline);
        return poppedLine;
    }

    private static Timeline move(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        boolean valid;
        if (tokens.length < 4) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for function move: %d (at least 4 are required)", tokens.length));
        }
        String partStr = tokens[1];
        if (!tweenables.containsKey(partStr)) {
            throw new IllegalArgumentException("Illgal part name for function move: " + partStr);
        }
        int part = tweenables.get(partStr);
        float time = Float.parseFloat(tokens[2]) * em.speed;
        float target = Float.parseFloat(tokens[3]);
        Tween tween = null;
        boolean bl = valid = model != null;
        if (valid) {
            tween = Tween.to(model, part, time).target(target);
        }
        if (tokens.length > 4) {
            int index = 4;
            block12: while (index < tokens.length) {
                String cmd;
                switch (cmd = tokens[index++]) {
                    case "delay": {
                        EmoteTemplate.assertParamSize("delay", tokens, 1, index);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.delay(delay);
                        continue block12;
                    }
                    case "yoyo": {
                        EmoteTemplate.assertParamSize("yoyo", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.repeatYoyo(times, delay);
                        continue block12;
                    }
                    case "repeat": {
                        EmoteTemplate.assertParamSize("repeat", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        float delay = Float.parseFloat(tokens[index++]) * em.speed;
                        if (!valid) continue block12;
                        tween = (Tween)tween.repeat(times, delay);
                        continue block12;
                    }
                    case "ease": {
                        EmoteTemplate.assertParamSize("ease", tokens, 1, index);
                        String easeType = tokens[index++];
                        if (equations.containsKey(easeType)) {
                            if (!valid) continue block12;
                            tween = tween.ease(equations.get(easeType));
                            continue block12;
                        }
                        throw new IllegalArgumentException("Easing type " + easeType + " doesn't exist");
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid modifier %s for move function", cmd));
            }
        }
        if (valid) {
            return timeline.push(tween);
        }
        return timeline;
    }

    private static Timeline reset(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        boolean off;
        if (tokens.length < 4) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for function reset: %d (at least 4 are required)", tokens.length));
        }
        String part = tokens[1];
        boolean allParts = part.equals("all");
        if (!allParts && !parts.containsKey(part)) {
            throw new IllegalArgumentException("Illgal part name for function reset: " + part);
        }
        String type = tokens[2];
        boolean all = type.equals("all");
        boolean rot = all || type.equals("rotation");
        boolean bl = off = all || type.equals("offset");
        if (!rot && !off) {
            throw new IllegalArgumentException("Illgal reset type: " + type);
        }
        int partInt = allParts ? 0 : parts.get(part);
        float time = Float.parseFloat(tokens[3]) * em.speed;
        if (model != null) {
            int lower;
            Timeline parallel = Timeline.createParallel();
            int n = allParts ? 0 : (lower = partInt + (rot ? 0 : 3));
            int upper = allParts ? 36 : partInt + (off ? 6 : 3);
            for (int i = lower; i < upper; ++i) {
                int piece = i / 6 * 6;
                if (!em.usedParts.contains(piece)) continue;
                parallel.push(Tween.to(model, i, time));
            }
            timeline.push(parallel);
        }
        return timeline;
    }

    private static Timeline pause(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 2);
        float ms = Float.parseFloat(tokens[1]) * em.speed;
        return timeline.pushPause(ms);
    }

    private static Timeline yoyo(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        float delay = Float.parseFloat(tokens[2]) * em.speed;
        return (Timeline)timeline.repeatYoyo(times, delay);
    }

    private static Timeline repeat(EmoteTemplate em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteTemplate.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        float delay = Float.parseFloat(tokens[2]) * em.speed;
        return (Timeline)timeline.repeat(times, delay);
    }

    private static void assertParamSize(String[] tokens, int expect) throws IllegalArgumentException {
        if (tokens.length != expect) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for function %s: %d (expected %d)", tokens[0], tokens.length, expect));
        }
    }

    private static void assertParamSize(String mod, String[] tokens, int expect, int startingFrom) throws IllegalArgumentException {
        if (tokens.length - startingFrom < expect) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for move modifier %s: %d (expected at least %d)", mod, tokens.length, expect));
        }
    }

    public boolean usesBodyPart(int part) {
        return this.usedParts.contains(part);
    }

    static {
        Field[] fields;
        parts = new HashMap<String, Integer>();
        tweenables = new HashMap<String, Integer>();
        functions = new HashMap<String, Function>();
        equations = new HashMap<String, TweenEquation>();
        functions.put("name", EmoteTemplate::name);
        functions.put("use", EmoteTemplate::use);
        functions.put("unit", EmoteTemplate::unit);
        functions.put("animation", EmoteTemplate::animation);
        functions.put("section", EmoteTemplate::section);
        functions.put("end", EmoteTemplate::end);
        functions.put("move", EmoteTemplate::move);
        functions.put("reset", EmoteTemplate::reset);
        functions.put("pause", EmoteTemplate::pause);
        functions.put("yoyo", EmoteTemplate::yoyo);
        functions.put("repeat", EmoteTemplate::repeat);
        functions.put("tier", EmoteTemplate::tier);
        Class clazz = ModelAccessor.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (f.getType() != Integer.TYPE || !Modifier.isPublic(modifiers = f.getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                int val = f.getInt(null);
                String name = f.getName().toLowerCase();
                if (name.matches("^.+?_[xyz]$")) {
                    tweenables.put(name, val);
                    continue;
                }
                parts.put(name, val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        clazz = TweenEquations.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            String name = f.getName().replaceAll("[A-Z]", "_$0").substring(5).toLowerCase();
            try {
                TweenEquation eq = (TweenEquation)f.get(null);
                equations.put(name, eq);
                if (!name.equals("none")) continue;
                equations.put("linear", eq);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static interface Function {
        public Timeline invoke(EmoteTemplate var1, ModelBiped var2, Timeline var3, String[] var4) throws IllegalArgumentException;
    }
}

