/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.feature.FairyRings;

public class FairyRingGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!FairyRings.dimensions.canSpawnHere(world)) {
            return;
        }
        int x = chunkX * 16 + 8 + random.nextInt(16);
        int z = chunkZ * 16 + 8 + random.nextInt(16);
        Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
        Set types = BiomeDictionary.getTypes((Biome)biome);
        int chance = 0;
        if (types.contains(BiomeDictionary.Type.FOREST)) {
            chance = FairyRings.forestChance;
        } else if (types.contains(BiomeDictionary.Type.PLAINS)) {
            chance = FairyRings.plainsChance;
        }
        if (chance > 0 && random.nextInt(chance) == 0) {
            BlockPos pos = new BlockPos(x, 128, z);
            IBlockState state = world.func_180495_p(pos);
            while (state.func_185904_a() != Material.field_151577_b && pos.func_177956_o() > 30) {
                pos = pos.func_177977_b();
                state = world.func_180495_p(pos);
            }
            if (state.func_185904_a() == Material.field_151577_b) {
                FairyRingGenerator.spawnFairyRing(world, pos.func_177977_b());
            }
        }
    }

    public static void spawnFairyRing(World world, BlockPos pos) {
        IBlockState flower = Blocks.field_150328_O.func_176203_a(8);
        for (int i = -3; i <= 3; ++i) {
            block1: for (int j = -3; j <= 3; ++j) {
                float dist = i * i + j * j;
                if (dist < 7.0f || dist > 10.0f) continue;
                for (int k = 5; k > -4; --k) {
                    BlockPos fpos = pos.func_177982_a(i, k, j);
                    BlockPos fposUp = fpos.func_177984_a();
                    IBlockState state = world.func_180495_p(fpos);
                    IBlockState stateUp = world.func_180495_p(fposUp);
                    if (state.func_185904_a() != Material.field_151577_b || !world.func_175623_d(fposUp) && !stateUp.func_177230_c().func_176200_f((IBlockAccess)world, fposUp)) continue;
                    world.func_175656_a(fpos.func_177984_a(), flower);
                    continue block1;
                }
            }
        }
        BlockPos orePos = pos.func_177979_c(world.field_73012_v.nextInt(10) + 25);
        IBlockState stoneState = world.func_180495_p(orePos);
        for (int down = 0; !(stoneState.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)stoneState.func_177229_b((IProperty)BlockStone.field_176247_a)).func_190912_e() || down >= 10); ++down) {
            orePos = orePos.func_177977_b();
            stoneState = world.func_180495_p(orePos);
        }
        if (stoneState.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)stoneState.func_177229_b((IProperty)BlockStone.field_176247_a)).func_190912_e()) {
            IBlockState ore = FairyRings.ores.get(world.field_73012_v.nextInt(FairyRings.ores.size()));
            world.func_175656_a(orePos, ore);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!world.field_73012_v.nextBoolean()) continue;
                world.func_175656_a(orePos.func_177972_a(face), ore);
            }
        }
    }
}

