/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.world.MultiChunkFeatureGenerator;

public class StoneInfoBasedGenerator
extends MultiChunkFeatureGenerator {
    public Supplier<RevampStoneGen.StoneInfo> infoSupplier;
    public String name;
    IBlockState state;
    long seedXor;

    public StoneInfoBasedGenerator(Supplier<RevampStoneGen.StoneInfo> infoSupplier, IBlockState state, String name) {
        this.infoSupplier = infoSupplier;
        this.name = name;
        this.state = state;
        this.seedXor = name.hashCode();
    }

    @Override
    public boolean canGenerate(World world, int chunkX, int chunkZ) {
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        return info.enabled && info.dims.canSpawnHere(world);
    }

    public boolean canGenerateInBiome(Biome b) {
        return BiomeTypeConfigHandler.biomeTypeIntersectCheck(this.infoSupplier.get().allowedBiomes, b);
    }

    @Override
    public boolean isSourceValid(World world, BlockPos pos) {
        return this.canGenerateInBiome(world.func_180494_b(pos));
    }

    @Override
    public long modifyWorldSeed(long seed) {
        return seed ^ this.seedXor;
    }

    @Override
    public int getFeatureRadius() {
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        return info.clusterSize;
    }

    @Override
    public void generateChunkPart(BlockPos src, Random random, int chunkX, int chunkZ, World world) {
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        this.forEachChunkBlock(chunkX, chunkZ, info.lowerBound - info.clusterSize, info.upperBound + info.clusterSize, pos -> {
            if (this.canPlaceBlock(world, (BlockPos)pos) && pos.func_177951_i((Vec3i)src) < (double)(info.clusterSize * info.clusterSize)) {
                world.func_180501_a(pos, this.state, 0);
            }
        });
    }

    public boolean canPlaceBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150348_b;
    }

    @Override
    public BlockPos[] getSourcesInChunk(Random random, int chunkX, int chunkZ, World world) {
        BlockPos[] sources;
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        int chance = info.clusterRarity;
        int amount = 1;
        if (info.clustersRarityPerChunk) {
            chance = 1;
            amount = info.clusterRarity;
        }
        if (chance > 0 && random.nextInt(chance) == 0) {
            sources = new BlockPos[amount];
            int lower = Math.abs(info.lowerBound);
            int range = Math.abs(info.upperBound - info.lowerBound);
            for (int i = 0; i < amount && range > 0; ++i) {
                BlockPos pos;
                int x = chunkX * 16 + random.nextInt(16) + 8;
                int y = random.nextInt(range) + lower;
                int z = chunkZ * 16 + random.nextInt(16) + 8;
                sources[i] = pos = new BlockPos(x, y, z);
            }
        } else {
            sources = new BlockPos[]{};
        }
        return sources;
    }
}

