/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeHelp;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.command.InvSeeInventory;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.server.command.CommandTreeBase;

public class CmdInv
extends CmdTreeBase {
    public CmdInv() {
        super("inv");
        this.addSubcommand((ICommand)new CmdView());
        this.addSubcommand((ICommand)new CmdSave());
        this.addSubcommand((ICommand)new CmdLoad());
        this.addSubcommand((ICommand)new CmdDisableRightClick());
        this.addSubcommand((ICommand)new CmdTreeHelp((CommandTreeBase)this));
    }

    public static class CmdDisableRightClick
    extends CmdBase {
        public CmdDisableRightClick() {
            super("disable_right_click", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            ItemStack stack;
            String s;
            LinkedHashSet<String> list = new LinkedHashSet<String>(Arrays.asList(FTBUtilitiesConfig.world.disabled_right_click_items));
            if (list.contains(s = (stack = CmdDisableRightClick.func_71521_c((ICommandSender)sender).func_184586_b(EnumHand.MAIN_HAND)).func_77973_b().getRegistryName() + (stack.func_77981_g() ? "@" + stack.func_77960_j() : ""))) {
                list.remove(s);
            } else {
                list.add(s);
            }
            FTBUtilitiesConfig.world.disabled_right_click_items = list.toArray(new String[0]);
            FTBUtilitiesConfig.sync();
        }
    }

    public static class CmdList
    extends CmdBase {
        public CmdList() {
            super("list", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        }
    }

    public static class CmdLoad
    extends CmdBase {
        public CmdLoad() {
            super("load", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 2);
            EntityPlayerMP player = CommandUtils.getForgePlayer((ICommandSender)sender, (String)args[0]).getCommandPlayer(sender);
            File file = new File(server.func_71238_n(), "local/ftbutilities/playerinvs/" + StringUtils.fromUUID((UUID)player.func_146103_bH().getId()) + "_" + args[1].toLowerCase() + ".dat");
            try {
                NBTTagCompound tag = NBTUtils.readNBT((File)file);
                CmdLoad.readItemsFromNBT((IInventory)player.field_71071_by, tag, "Inventory");
            }
            catch (Exception ex) {
                if (FTBLibConfig.debugging.print_more_errors) {
                    ex.printStackTrace();
                }
                throw FTBLib.error((ICommandSender)sender, (String)"error", (Object[])new Object[]{ex.toString()});
            }
        }

        private static void readItemsFromNBT(@Nullable IInventory inv, NBTTagCompound compound, String s) {
            if (inv == null) {
                return;
            }
            NBTTagList nbttaglist = compound.func_150295_c(s, 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74762_e("Slot");
                if (j < 0 || j >= inv.func_70302_i_()) continue;
                inv.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        }
    }

    public static class CmdSave
    extends CmdBase {
        public CmdSave() {
            super("save", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 2);
            EntityPlayerMP player = CommandUtils.getForgePlayer((ICommandSender)sender, (String)args[0]).getCommandPlayer(sender);
            File file = new File(server.func_71238_n(), "local/ftbutilities/playerinvs/" + StringUtils.fromUUID((UUID)player.func_146103_bH().getId()) + "_" + args[1].toLowerCase() + ".dat");
            try {
                NBTTagCompound tag = new NBTTagCompound();
                CmdSave.writeItemsToNBT((IInventory)player.field_71071_by, tag, "Inventory");
                NBTUtils.writeNBT((File)file, (NBTTagCompound)tag);
            }
            catch (Exception ex) {
                if (FTBLibConfig.debugging.print_more_errors) {
                    ex.printStackTrace();
                }
                throw FTBLib.error((ICommandSender)sender, (String)"error", (Object[])new Object[]{ex.toString()});
            }
        }

        private static void writeItemsToNBT(IInventory inv, NBTTagCompound compound, String s) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = is.serializeNBT();
                nbttagcompound.func_74768_a("Slot", i);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a(s, (NBTBase)nbttaglist);
        }
    }

    public static class CmdView
    extends CmdBase {
        public CmdView() {
            super("view", CmdBase.Level.OP);
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("edit");
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 1);
            EntityPlayerMP self = CmdView.func_71521_c((ICommandSender)sender);
            EntityPlayerMP other = CommandUtils.getForgePlayer((ICommandSender)sender, (String)args[0]).getCommandPlayer(sender);
            self.func_71007_a((IInventory)new InvSeeInventory((IInventory)other.field_71071_by, other));
        }
    }
}

