/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.BlockDimPosStorage;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.backups.Backups;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesUniverseData {
    private static final String BADGE_URL = "https://badges.latmod.com/get?id=";
    private static final ResourceLocation RESTART_TIMER_ID = new ResourceLocation("ftbutilities", "restart_timer");
    private static final Map<UUID, String> BADGE_CACHE = new HashMap<UUID, String>();
    private static final Map<UUID, String> LOCAL_BADGES = new HashMap<UUID, String>();
    public static long shutdownTime;
    public static final BlockDimPosStorage WARPS;
    private static final List<String> worldLog;

    public static boolean isInSpawn(MinecraftServer server, ChunkDimPos pos) {
        if (pos.dim != 0 || !server.func_71262_S() && !FTBUtilitiesConfig.world.spawn_area_in_sp) {
            return false;
        }
        int radius = FTBUtilitiesConfig.world.spawn_radius;
        if (radius <= 0) {
            return false;
        }
        BlockPos c = server.func_71218_a(0).func_175694_M();
        int minX = MathUtils.chunk((int)(c.func_177958_n() - radius));
        int minZ = MathUtils.chunk((int)(c.func_177952_p() - radius));
        int maxX = MathUtils.chunk((int)(c.func_177958_n() + radius));
        int maxZ = MathUtils.chunk((int)(c.func_177952_p() + radius));
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    @SubscribeEvent
    public static void onUniversePreLoaded(UniverseLoadedEvent.Pre event) {
        if (FTBUtilitiesConfig.world.chunk_claiming) {
            ClaimedChunks.instance = new ClaimedChunks(event.getUniverse());
        }
        Ranks.INSTANCE = new Ranks(event.getUniverse());
    }

    @SubscribeEvent
    public static void onUniversePostLoaded(UniverseLoadedEvent.Post event) {
        NBTTagCompound nbt = event.getData("ftbutilities");
        WARPS.deserializeNBT(nbt.func_74775_l("Warps"));
    }

    @SubscribeEvent
    public static void onUniverseLoaded(UniverseLoadedEvent.Finished event) {
        long now = System.currentTimeMillis();
        shutdownTime = 0L;
        Backups.INSTANCE.nextBackup = now + FTBUtilitiesConfig.backups.time();
        if (FTBUtilitiesConfig.auto_shutdown.enabled && FTBUtilitiesConfig.auto_shutdown.times.length > 0 && (FTBUtilitiesConfig.auto_shutdown.enabled_singleplayer || event.getUniverse().server.func_71262_S())) {
            Calendar calendar = Calendar.getInstance();
            int currentTime = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            ArrayList<Integer> times = new ArrayList<Integer>(FTBUtilitiesConfig.auto_shutdown.times.length);
            for (String s0 : FTBUtilitiesConfig.auto_shutdown.times) {
                try {
                    String[] s = s0.split(":", 2);
                    int t = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60;
                    if (t <= currentTime) {
                        t += 86400;
                    }
                    times.add(t);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            times.sort(null);
            Iterator iterator = times.iterator();
            while (iterator.hasNext()) {
                int time = (Integer)iterator.next();
                if (time <= currentTime) continue;
                shutdownTime = now + (long)(time - currentTime) * 1000L;
                break;
            }
            if (shutdownTime > 0L) {
                Ticks[] ticks;
                FTBUtilities.LOGGER.info("Server will shut down in " + StringUtils.getTimeString((long)(shutdownTime - now)));
                for (Ticks t : ticks = new Ticks[]{Ticks.MINUTE.x(30L), Ticks.MINUTE.x(10L), Ticks.MINUTE.x(5L), Ticks.MINUTE.x(1L), Ticks.SECOND.x(10L), Ticks.SECOND.x(9L), Ticks.SECOND.x(8L), Ticks.SECOND.x(7L), Ticks.SECOND.x(6L), Ticks.SECOND.x(5L), Ticks.SECOND.x(4L), Ticks.SECOND.x(3L), Ticks.SECOND.x(2L), Ticks.SECOND.x(1L)}) {
                    event.getUniverse().scheduleTask(TimeType.MILLIS, shutdownTime - t.millis(), universe -> {
                        String timeString = t.toTimeString();
                        for (EntityPlayerMP player : universe.server.func_184103_al().func_181057_v()) {
                            Notification.of((ResourceLocation)RESTART_TIMER_ID, (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.timer.shutdown", timeString), (TextFormatting)TextFormatting.LIGHT_PURPLE)}).send(universe.server, (EntityPlayer)player);
                        }
                    });
                }
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.nextChunkloaderUpdate = now + 1000L;
        }
    }

    public static void worldLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        FTBUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        FTBUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        FTBUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        FTBUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        FTBUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        FTBUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        worldLog.add(out.toString());
        Universe.get().markDirty();
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @SubscribeEvent
    public static void onUniverseSaved(UniverseSavedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.processQueue();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Warps", (NBTBase)WARPS.serializeNBT());
        event.setData("ftbutilities", nbt);
        if (!worldLog.isEmpty()) {
            ArrayList<String> worldLogCopy = new ArrayList<String>(worldLog);
            worldLog.clear();
            ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile((File)new File(event.getUniverse().server.func_71238_n(), "logs/world.log")), true)));){
                    for (String s : worldLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public static void onUniverseClosed(UniverseClosedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.clear();
            ClaimedChunks.instance = null;
        }
        FTBUtilitiesLoadedChunkManager.INSTANCE.clear();
        BADGE_CACHE.clear();
        LOCAL_BADGES.clear();
    }

    public static void updateBadge(UUID playerId) {
        BADGE_CACHE.remove(playerId);
    }

    public static String getBadge(Universe universe, UUID playerId) {
        String badge = BADGE_CACHE.get(playerId);
        if (badge != null) {
            return badge;
        }
        badge = FTBUtilitiesUniverseData.getRawBadge(universe, playerId);
        BADGE_CACHE.put(playerId, badge);
        return badge;
    }

    private static String getRawBadge(Universe universe, UUID playerId) {
        String badge;
        ForgePlayer player;
        block6: {
            player = universe.getPlayer(playerId);
            if (player == null || player.isFake()) {
                return "";
            }
            FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(player);
            if (!data.renderBadge()) {
                return "";
            }
            if (FTBUtilitiesConfig.login.enable_global_badges && !data.disableGlobalBadge()) {
                try {
                    badge = DataReader.get((URL)new URL(BADGE_URL + StringUtils.fromUUID((UUID)playerId)), (String)"text/plain; charset=utf-8", (Proxy)universe.server.func_110454_ao()).string(32);
                    if (!badge.isEmpty()) {
                        return badge;
                    }
                }
                catch (Exception ex) {
                    if (!FTBLibConfig.debugging.print_more_errors) break block6;
                    FTBUtilities.LOGGER.warn("Badge API errored! " + ex);
                }
            }
        }
        return (badge = LOCAL_BADGES.get(playerId)) == null || badge.isEmpty() ? player.getRankConfig(FTBUtilitiesPermissions.BADGE).getString() : badge;
    }

    public static boolean reloadServerBadges(Universe universe) {
        BADGE_CACHE.clear();
        LOCAL_BADGES.clear();
        try {
            File file = new File(universe.server.func_71238_n(), "local/ftbutilities/server_badges.json");
            if (!file.exists()) {
                file = new File(universe.server.func_71238_n(), "local/ftbutilities/server_badges.txt");
                if (!file.exists()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("// username: url2_to.png");
                    list.add("// uuid: url_to.png");
                    list.add("// For more info see https://guides.latmod.com/ftbutilities/ranks/badges/");
                    FileUtils.saveSafe((File)file, list);
                } else {
                    for (String s : DataReader.get((File)file).safeStringList()) {
                        ForgePlayer player;
                        String[] s1;
                        if (s.isEmpty() || s.startsWith("//") || (s1 = s.trim().split(":", 2)).length != 2 || (player = universe.getPlayer((CharSequence)s1[0].trim())) == null) continue;
                        LOCAL_BADGES.put(player.getId(), s1[1].trim());
                    }
                }
            } else {
                for (Map.Entry entry : DataReader.get((File)file).json().getAsJsonObject().entrySet()) {
                    ForgePlayer player = universe.getPlayer((CharSequence)entry.getKey());
                    if (player == null) continue;
                    LOCAL_BADGES.put(player.getId(), ((JsonElement)entry.getValue()).getAsString());
                }
                FileUtils.deleteSafe((File)file);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static {
        WARPS = new BlockDimPosStorage();
        worldLog = new ArrayList<String>();
    }
}

