/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClient;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClientConfig;
import com.feed_the_beast.ftbutilities.gui.GuiClaimedChunks;
import com.feed_the_beast.ftbutilities.net.MessageEditNBTRequest;
import com.feed_the_beast.ftbutilities.net.MessageLeaderboardList;
import com.feed_the_beast.ftbutilities.net.MessageRequestBadge;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbutilities", value={Side.CLIENT})
public class FTBUtilitiesClientEventHandler {
    private static final Map<UUID, Icon> BADGE_CACHE = new HashMap<UUID, Icon>();
    public static int currentBackupFile = 0;
    public static int totalBackupFiles = 0;
    public static long shutdownTime = 0L;

    public static void readSyncData(NBTTagCompound nbt) {
        shutdownTime = System.currentTimeMillis() + nbt.func_74763_f("ShutdownTime");
    }

    public static Icon getBadge(UUID id) {
        Icon tex = BADGE_CACHE.get(id);
        if (tex == null) {
            tex = Icon.EMPTY;
            BADGE_CACHE.put(id, tex);
            new MessageRequestBadge(id).sendToServer();
        }
        return tex;
    }

    public static void setBadge(UUID id, String url) {
        BADGE_CACHE.put(id, Icon.getIcon((String)url));
    }

    @SubscribeEvent
    public static void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        BADGE_CACHE.clear();
        currentBackupFile = 0;
        totalBackupFiles = 0;
        shutdownTime = 0L;
    }

    @SubscribeEvent
    public static void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        long timeLeft;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (shutdownTime > 0L && FTBUtilitiesClientConfig.general.show_shutdown_timer && (timeLeft = Math.max(0L, shutdownTime - System.currentTimeMillis())) > 0L && timeLeft <= FTBUtilitiesClientConfig.general.getShowShutdownTimer()) {
            event.getLeft().add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"ftbutilities.lang.timer.shutdown", (Object[])new Object[]{StringUtils.getTimeString((long)timeLeft)}));
        }
        if (totalBackupFiles > 0 && totalBackupFiles > currentBackupFile && FTBUtilitiesClientConfig.general.show_backup_progress) {
            event.getLeft().add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"ftbutilities.lang.timer.backup_progress", (Object[])new Object[]{currentBackupFile * 100 / totalBackupFiles, currentBackupFile, totalBackupFiles}));
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBUtilitiesClient.KEY_NBT.func_151468_f()) {
            MessageEditNBTRequest.editNBT();
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbutilities")) {
            switch (event.getID().func_110623_a()) {
                case "toggle_gamemode": {
                    ClientUtils.execClientCommand((String)("/gamemode " + (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? "survival" : "creative")));
                    break;
                }
                case "daytime": {
                    ClientUtils.execClientCommand((String)("/time add " + (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + 6000L) % 24000L));
                    break;
                }
                case "nighttime": {
                    ClientUtils.execClientCommand((String)("/time add " + (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + 18000L) % 24000L));
                    break;
                }
                case "claims_gui": {
                    GuiClaimedChunks.instance = new GuiClaimedChunks();
                    GuiClaimedChunks.instance.openGui();
                    break;
                }
                case "leaderboards_gui": {
                    new MessageLeaderboardList().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }
}

