/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.google.common.base.Preconditions;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBeeFactory;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.BranchBees;
import forestry.apiculture.genetics.alleles.AlleleBeeSpecies;

public class BeeFactory
implements IBeeFactory {
    @Override
    public IAlleleBeeSpeciesBuilder createSpecies(String modId, String uid, boolean dominant, String authority, String unlocalizedName, String unlocalizedDescription, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        Preconditions.checkNotNull((Object)uid);
        Preconditions.checkNotNull((Object)authority);
        Preconditions.checkNotNull((Object)unlocalizedName);
        Preconditions.checkNotNull((Object)unlocalizedDescription);
        Preconditions.checkNotNull((Object)branch);
        return new AlleleBeeSpecies(modId, uid, unlocalizedName, authority, unlocalizedDescription, dominant, branch, binomial, primaryColor, secondaryColor);
    }

    @Override
    public IClassification createBranch(String uid, String scientific) {
        return new BranchBees(uid, scientific);
    }

    @Override
    @Deprecated
    public IAlleleBeeSpeciesBuilder createSpecies(String uid, boolean dominant, String authority, String unlocalizedName, String unlocalizedDescription, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        return this.createSpecies("forestry", uid, dominant, authority, unlocalizedName, unlocalizedDescription, branch, binomial, primaryColor, secondaryColor);
    }
}

