/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui;

import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IForesterBook;
import forestry.book.gui.GuiForesterBook;
import forestry.book.gui.GuiForestryBookCategories;
import forestry.book.gui.GuiForestryBookPages;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonEntry;
import forestry.book.gui.buttons.GuiButtonPage;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiForestryBookEntries
extends GuiForesterBook {
    private final IBookCategory category;
    private int entryIndex = 0;

    public GuiForestryBookEntries(IForesterBook book, IBookCategory category) {
        super(book);
        this.category = category;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int offset = this.entryIndex * 24;
        this.addEntryButtons(offset, 16, 25);
        this.addEntryButtons(offset + 12, 132, 12);
        this.window.init(this.guiLeft, this.guiTop);
        this.window.clear();
    }

    private void addEntryButtons(int indexStart, int xStart, int yStart) {
        ArrayList<IBookEntry> entries = new ArrayList<IBookEntry>(this.category.getEntries());
        if (indexStart >= entries.size()) {
            return;
        }
        int maxIndex = entries.size() > indexStart + 12 ? indexStart + 12 : entries.size();
        int yOffset = 0;
        for (int i = indexStart; i < maxIndex; ++i) {
            IBookEntry entry = (IBookEntry)entries.get(i);
            this.func_189646_b(new GuiButtonEntry(this.field_146292_n.size(), this.guiLeft + xStart, this.guiTop + yStart + yOffset, entry));
            yOffset += this.field_146289_q.field_78288_b + 2;
        }
    }

    @Override
    protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
        leftButton.field_146125_m = this.entryIndex > 0;
        rightButton.field_146125_m = this.category.getEntries().size() > (this.entryIndex + 1) * 24;
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiButtonPage) {
            GuiButtonPage pageButton = (GuiButtonPage)button;
            this.entryIndex = pageButton.left ? --this.entryIndex : ++this.entryIndex;
            this.func_73866_w_();
        } else if (button instanceof GuiButtonBack) {
            this.displayCategories();
        } else if (button instanceof GuiButtonEntry) {
            GuiButtonEntry entry = (GuiButtonEntry)button;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiForestryBookPages(this.book, this.category, entry.entry, null));
        }
    }

    private void displayCategories() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiForestryBookCategories(this.book));
    }

    @Override
    protected String getTitle() {
        return this.category.getLocalizedName();
    }
}

