/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.collect.ImmutableMap;
import forestry.api.recipes.ICentrifugeRecipe;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CentrifugeRecipe
implements ICentrifugeRecipe {
    private final int processingTime;
    private final ItemStack input;
    private final Map<ItemStack, Float> outputs;

    public CentrifugeRecipe(int processingTime, ItemStack input, Map<ItemStack, Float> outputs) {
        this.processingTime = processingTime;
        this.input = input;
        this.outputs = outputs;
        for (ItemStack item : outputs.keySet()) {
            if (item != null) continue;
            throw new IllegalArgumentException("Tried to register a null product of " + input);
        }
    }

    @Override
    public ItemStack getInput() {
        return this.input;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public NonNullList<ItemStack> getProducts(Random random) {
        NonNullList products = NonNullList.func_191196_a();
        for (Map.Entry<ItemStack, Float> entry : this.outputs.entrySet()) {
            float probability = entry.getValue().floatValue();
            if ((double)probability >= 1.0) {
                products.add((Object)entry.getKey().func_77946_l());
                continue;
            }
            if (!(random.nextFloat() < probability)) continue;
            products.add((Object)entry.getKey().func_77946_l());
        }
        return products;
    }

    @Override
    public Map<ItemStack, Float> getAllProducts() {
        return ImmutableMap.copyOf(this.outputs);
    }
}

