/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.traits.AbstractArmorTrait;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TraitEnderport
extends AbstractArmorTrait {
    private static final float MODIFIER = 0.25f;

    public TraitEnderport() {
        super("enderport", TextFormatting.DARK_AQUA);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        int level;
        if (evt.getEntityLiving() instanceof EntityPlayer && this.isStuck(evt.getSource()) && (level = (int)ArmorHelper.getArmorAbilityLevel((EntityPlayer)evt.getEntityLiving(), this.getModifierIdentifier())) > 0 && random.nextFloat() < 0.25f * (float)level) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly(evt.getEntityLiving())) continue;
                return;
            }
        }
    }

    protected boolean isStuck(DamageSource source) {
        return source == DamageSource.field_76371_c || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d;
    }

    protected boolean teleportRandomly(EntityLivingBase entity) {
        double z;
        double y;
        double x = entity.field_70165_t + (random.nextDouble() - 0.5) * 64.0;
        EnderTeleportEvent evt = new EnderTeleportEvent(entity, x, y = entity.field_70163_u + (double)(random.nextInt(64) - 32), z = entity.field_70161_v + (random.nextDouble() - 0.5) * 64.0, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        boolean flag = this.attemptTeleport(entity, evt.getTargetX(), evt.getTargetY(), evt.getTargetZ());
        if (flag) {
            entity.field_70170_p.func_184148_a(null, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    private boolean attemptTeleport(EntityLivingBase entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)entity);
        World world = entity.field_70170_p;
        Random random = entity.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    boolean bl = flag = !world.func_72953_d(entity.func_174813_aQ()) || entity.func_70055_a(Material.field_151586_h) && world.func_175623_d(entity.func_180425_c().func_177984_a());
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (entity.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d4 = d1 + (entity.field_70163_u - d1) * d6 + random.nextDouble() * (double)entity.field_70131_O;
            double d5 = d2 + (entity.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }
}

