/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.base.attributes.generic;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeBoolean
implements IAttribute<Boolean> {
    public static final Class CALCULATOR_OR = ACalcBooleanOR.class;
    public static final Class CALCULATOR_AND = ACalcBooleanAND.class;
    protected AttributeID attributeID;
    protected boolean value;

    public AttributeBoolean(AttributeID attributeID, boolean value) {
        this.attributeID = attributeID;
        this.value = value;
    }

    @Override
    public AttributeID getAttributeID() {
        return this.attributeID;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public static final class ACalcBooleanAND
    extends AAttributeCalculator<AttributeBoolean, Boolean, Boolean, Boolean> {
        @Override
        public Boolean calculateFinalValue(List<IAttribute<Boolean>> attributes) {
            for (IAttribute<Boolean> iAttribute : attributes) {
                if (iAttribute.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean calculateModifiedValue(Boolean attributeFinalValue, Boolean unmodifiedValue) {
            return attributeFinalValue;
        }

        @Override
        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return nbt.func_74767_n(this.getAttribute().toString());
        }

        @Override
        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Boolean data = (Boolean)obj;
            nbt.func_74757_a(this.getAttribute().toString(), data.booleanValue());
            return nbt;
        }

        @Override
        public int getLargerFinalValue(Object firstFinalValue, Object secondFinalValue) {
            Boolean first = (Boolean)firstFinalValue;
            Boolean secnd = (Boolean)secondFinalValue;
            if (first.booleanValue() && !secnd.booleanValue()) {
                return 1;
            }
            if (!first.booleanValue() && secnd.booleanValue()) {
                return 2;
            }
            return 0;
        }
    }

    public static final class ACalcBooleanOR
    extends AAttributeCalculator<AttributeBoolean, Boolean, Boolean, Boolean> {
        @Override
        public Boolean calculateFinalValue(List<IAttribute<Boolean>> attributes) {
            for (IAttribute<Boolean> iAttribute : attributes) {
                if (!iAttribute.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean calculateModifiedValue(Boolean attributeFinalValue, Boolean unmodifiedValue) {
            return attributeFinalValue;
        }

        @Override
        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return nbt.func_74767_n(this.getAttribute().toString());
        }

        @Override
        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Boolean data = (Boolean)obj;
            nbt.func_74757_a(this.getAttribute().toString(), data.booleanValue());
            return nbt;
        }

        @Override
        public int getLargerFinalValue(Object firstFinalValue, Object secondFinalValue) {
            Boolean first = (Boolean)firstFinalValue;
            Boolean secnd = (Boolean)secondFinalValue;
            if (first.booleanValue() && !secnd.booleanValue()) {
                return 1;
            }
            if (!first.booleanValue() && secnd.booleanValue()) {
                return 2;
            }
            return 0;
        }
    }
}

