/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util;

import java.util.regex.Pattern;

public class StringUtils {
    public static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitleCase = true;
        if (input != null) {
            for (char c : input.toCharArray()) {
                if (Character.isSpaceChar(c)) {
                    nextTitleCase = true;
                } else if (nextTitleCase) {
                    c = Character.toTitleCase(c);
                    nextTitleCase = false;
                }
                titleCase.append(c);
            }
        }
        return titleCase.toString();
    }

    public static String formatNumber(int num) {
        return String.format("%,d", num);
    }

    public static int getInt(String n) {
        boolean useLong;
        if (!Pattern.matches("^[0-9]*$", n)) {
            return 0;
        }
        if (StringUtils.isNullOrEmpty(n)) {
            return 0;
        }
        String trimmed = n.substring(0, Math.min(n.length(), 10));
        boolean bl = useLong = trimmed.length() > 9;
        if (useLong) {
            long l = Long.parseLong(trimmed);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
        }
        int i = Integer.parseInt(trimmed);
        return i;
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isNullOrEmpty(str) || StringUtils.isNullOrEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, int num) {
        if (StringUtils.isNullOrEmpty(str) || num > str.length()) {
            return str;
        }
        return str.substring(0, str.length() - num);
    }
}

