/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.structure;

import com.valkyrieofnight.vlib.multiblock.api.structure.IBlockOffset;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockOffset
implements IBlockOffset {
    private int x;
    private int y;
    private int z;

    public BlockOffset(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockOffset() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public BlockOffset(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Override
    public BlockPos getPosition(BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.x, centerPos.func_177956_o() + this.y, centerPos.func_177952_p() + this.z);
    }

    @Override
    public BlockPos getRotatedPosition(EnumFacing dir, BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.getX(dir), centerPos.func_177956_o() + this.getY(dir), centerPos.func_177952_p() + this.getZ(dir));
    }

    private int getX(EnumFacing dir) {
        switch (dir) {
            case EAST: {
                return -this.z;
            }
            case SOUTH: {
                return -this.x;
            }
            case WEST: {
                return this.z;
            }
        }
        return this.x;
    }

    private int getY(EnumFacing dir) {
        return this.y;
    }

    private int getZ(EnumFacing dir) {
        switch (dir) {
            case EAST: {
                return this.x;
            }
            case SOUTH: {
                return -this.z;
            }
            case WEST: {
                return -this.x;
            }
        }
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockOffset) {
            return this.same((BlockOffset)obj);
        }
        return false;
    }

    private BlockOffset getOffset(EnumFacing dir) {
        return new BlockOffset(this.getX(dir), this.y, this.getZ(dir));
    }

    @Override
    public boolean same(IBlockOffset oth) {
        return this.x == oth.getXOffset() && this.y == oth.getYOffset() && this.z == oth.getZOffset();
    }

    @Override
    public int getXOffset() {
        return this.x;
    }

    @Override
    public int getYOffset() {
        return this.y;
    }

    @Override
    public int getZOffset() {
        return this.z;
    }

    public String toString() {
        String str = "(";
        str = str + this.x + "," + this.y + "," + this.z + ")";
        return str;
    }

    public static BlockOffset getOffset(BlockPos pos, BlockPos offset) {
        return new BlockOffset(pos.func_177973_b((Vec3i)offset));
    }
}

