/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import crazypants.enderio.base.config.config.DiagnosticsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Log {
    public static final boolean inDev = System.getProperty("INDEV") != null;
    public static final Logger LOGGER = LogManager.getLogger((String)"enderio");

    public static void warn(Object ... msg) {
        LOGGER.warn(Log.join("", msg));
    }

    public static void error(Object ... msg) {
        LOGGER.error(Log.join("", msg));
    }

    public static void info(Object ... msg) {
        LOGGER.info(Log.join("", msg));
    }

    public static void debug(Object ... msg) {
        if (inDev) {
            LOGGER.info("INDEV: " + Log.join("", msg));
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Log.join("", msg));
        }
    }

    public static void livetraceNBT(Object ... msg) {
        if (((Boolean)DiagnosticsConfig.debugTraceNBTActivityExtremelyDetailed.get()).booleanValue()) {
            LOGGER.info(Log.join("", msg));
        }
    }

    public static String join(CharSequence delimiter, Object ... elements) {
        StringBuilder joiner = new StringBuilder();
        for (Object cs : elements) {
            if (joiner.length() != 0) {
                joiner.append(delimiter);
            }
            joiner.append(cs);
        }
        return joiner.toString();
    }

    private Log() {
    }
}

