/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.util.CapturedMob;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;

public class Entity
implements RecipeConfigElement {
    protected String name;
    protected transient CapturedMob mob = null;
    private double costMultiplier = 1.0;
    private boolean disabled = false;
    private boolean isDefault = false;
    private boolean isBoss = false;
    private boolean clone = false;
    private boolean soulvial = true;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.name == null || this.name.trim().isEmpty()) {
            this.mob = null;
            return this;
        }
        if (this.name.trim().equals("*")) {
            this.isDefault = true;
            if (this.clone) {
                throw new InvalidRecipeConfigException("Cannot set the default energy cost entry to 'clone'");
            }
            if (!this.soulvial) {
                throw new InvalidRecipeConfigException("Cannot set the default energy cost entry to not 'soulvial'");
            }
        } else if (this.name.trim().equals("*boss*")) {
            this.isBoss = true;
            if (this.clone) {
                throw new InvalidRecipeConfigException("Cannot set the 'all bosses' entry to 'clone'");
            }
        } else {
            this.mob = CapturedMob.create(new ResourceLocation(this.name.trim()));
            if (this.mob == null) {
                Log.info("Could not find an entity for '" + this.name + "'");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            Log.warn("Could not find an entity for '" + this.name + "'");
            Log.warn("Available entities are:");
            for (CapturedMob possible : CapturedMob.getAllSouls()) {
                Log.warn(" -> " + possible.getEntityName() + " (" + possible.getDisplayName() + ")");
            }
            throw new InvalidRecipeConfigException("Could not find an entity for '" + this.name + "'");
        }
    }

    @Override
    public boolean isValid() {
        return this.isDefault || this.isBoss || this.mob != null;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("costMultiplier".equals(name)) {
            try {
                this.costMultiplier = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'amount': Not a number");
            }
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        if ("clone".equals(name)) {
            this.clone = Boolean.parseBoolean(value);
            return true;
        }
        if ("soulvial".equals(name)) {
            this.soulvial = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    public double getCostMultiplier() {
        return this.costMultiplier;
    }

    public CapturedMob getMob() {
        return this.mob;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public boolean isClone() {
        return this.clone;
    }

    public boolean isSoulvial() {
        return this.soulvial;
    }
}

