/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Fluid;
import crazypants.enderio.base.config.recipes.xml.FluidMultiplier;
import crazypants.enderio.base.config.recipes.xml.Inputgroup;
import crazypants.enderio.base.config.recipes.xml.ItemMultiplier;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Fermenting
extends AbstractConditional {
    private int energy;
    private NNList<Inputgroup> inputgroup = new NNList();
    private FluidMultiplier inputfluid;
    private Fluid outputfluid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.inputgroup.size() < 1 || this.inputgroup.size() > 2) {
                throw new InvalidRecipeConfigException("Wrong number of <inputgroup>");
            }
            if (this.energy <= 0) {
                throw new InvalidRecipeConfigException("Invalid low value for 'energy'");
            }
            this.valid = this.inputfluid.isValid() && this.outputfluid.isValid();
            for (Inputgroup input : this.inputgroup) {
                this.valid = this.valid && input.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <fermenting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Inputgroup input : this.inputgroup) {
            input.enforceValidity();
        }
        this.inputfluid.enforceValidity();
        this.outputfluid.enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            NNList inputStacks = new NNList();
            int slot = 0;
            NNList.NNIterator itr = this.inputgroup.fastIterator();
            while (itr.hasNext()) {
                NNList.NNIterator itr2 = ((Inputgroup)itr.next()).getItems().fastIterator();
                while (itr2.hasNext()) {
                    ItemMultiplier item = (ItemMultiplier)itr2.next();
                    inputStacks.add((Object)new ThingsRecipeInput(item.getThing(), slot, item.multiplier));
                }
                ++slot;
            }
            inputStacks.add((Object)new RecipeInput(this.inputfluid.getFluidStack(), this.inputfluid.multiplier));
            RecipeOutput recipeOutput = new RecipeOutput(this.outputfluid.getFluidStack());
            VatRecipeManager.getInstance().addRecipe(new Recipe(recipeOutput, this.energy, RecipeBonusType.NONE, (IRecipeInput[])inputStacks.toArray((Object[])new IRecipeInput[inputStacks.size()])));
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("inputgroup".equals(name)) {
            this.inputgroup.add((Object)factory.read(new Inputgroup(), startElement));
            return true;
        }
        if ("inputfluid".equals(name)) {
            this.inputfluid = factory.read(new FluidMultiplier(), startElement);
            return true;
        }
        if ("outputfluid".equals(name)) {
            this.outputfluid = factory.read(new Fluid(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

