/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.ItemMultiplier;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Inputgroup
implements RecipeConfigElement {
    private NNList<ItemMultiplier> inputs = new NNList();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.inputs.isEmpty()) {
            throw new InvalidRecipeConfigException("Missing <input> in <inputgroup>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Item item : this.inputs) {
            if (!item.isValid()) continue;
            item.enforceValidity();
            return;
        }
        throw new InvalidRecipeConfigException("No valid <input> in <inputgroup>");
    }

    @Override
    public boolean isValid() {
        for (Item item : this.inputs) {
            if (!item.isValid()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public NNList<ItemMultiplier> getItems() {
        NNList result = new NNList();
        for (ItemMultiplier item : this.inputs) {
            if (!item.isValid()) continue;
            result.add((Object)item);
        }
        return result;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name)) {
            this.inputs.add(factory.read(new ItemMultiplier().setAllowDelaying(false), startElement));
            return true;
        }
        return false;
    }
}

