/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;

public class ItemOptional
implements RecipeConfigElement {
    protected transient boolean allowDelaying = false;
    protected String name;
    protected String nbt;
    protected transient boolean nullItem;
    @Nonnull
    protected final transient Things thing = new Things();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.name == null || this.name.trim().isEmpty()) {
            this.nullItem = true;
            return this;
        }
        this.thing.add(this.name);
        String nbt_nullchecked = this.nbt;
        if (nbt_nullchecked != null && !nbt_nullchecked.trim().isEmpty()) {
            try {
                this.thing.setNbt(JsonToNBT.func_180713_a((String)nbt_nullchecked));
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException(nbt_nullchecked + " is not valid NBT json.");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            throw new InvalidRecipeConfigException("Could not find a crafting ingredient for '" + this.name);
        }
    }

    @Override
    public boolean isValid() {
        return this.nullItem || (this.allowDelaying ? this.thing.isPotentiallyValid() : this.thing.isValid());
    }

    public Ingredient getRecipeObject() {
        return this.nullItem ? null : this.thing.asIngredient();
    }

    @Nonnull
    public ItemStack getItemStack() {
        ItemStack itemStack = this.thing.getItemStack();
        itemStack.func_190920_e(1);
        return itemStack;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Nonnull
    public Things getThing() {
        return this.thing;
    }

    public <T extends ItemOptional> T setAllowDelaying(boolean allowDelaying) {
        this.allowDelaying = allowDelaying;
        return (T)this;
    }
}

